/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.type.EsField;

public final class TypeResolutions {
    private TypeResolutions() {
    }

    public static Expression.TypeResolution isBoolean(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, dt -> dt == DataType.BOOLEAN, operationName, paramOrd, "boolean");
    }

    public static Expression.TypeResolution isInteger(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isInteger, operationName, paramOrd, "integer");
    }

    public static Expression.TypeResolution isNumeric(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isNumeric, operationName, paramOrd, "numeric");
    }

    public static Expression.TypeResolution isString(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isString, operationName, paramOrd, "string");
    }

    public static Expression.TypeResolution isDate(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isDateBased, operationName, paramOrd, "date", "datetime");
    }

    public static Expression.TypeResolution isDateOrTime(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isDateOrTimeBased, operationName, paramOrd, "date", "time", "datetime");
    }

    public static Expression.TypeResolution isNumericOrDate(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, dt -> dt.isNumeric() || dt.isDateBased(), operationName, paramOrd, "date", "datetime", "numeric");
    }

    public static Expression.TypeResolution isNumericOrDateOrTime(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, dt -> dt.isNumeric() || dt.isDateOrTimeBased(), operationName, paramOrd, "date", "time", "datetime", "numeric");
    }

    public static Expression.TypeResolution isGeo(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType(e, DataType::isGeo, operationName, paramOrd, "geo_point", "geo_shape");
    }

    public static Expression.TypeResolution isExact(Expression e, String message) {
        EsField.Exact exact;
        if (e instanceof FieldAttribute && !(exact = ((FieldAttribute)e).getExactInfo()).hasExact()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)message, (Object[])new Object[]{e.dataType().typeName, exact.errorMsg()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isExact(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        EsField.Exact exact;
        if (e instanceof FieldAttribute && !(exact = ((FieldAttribute)e).getExactInfo()).hasExact()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] cannot operate on {}field of data type [{}]: {}", (Object[])new Object[]{operationName, paramOrd == null || paramOrd == Expressions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " argument ", e.dataType().typeName, exact.errorMsg()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isStringAndExact(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        Expression.TypeResolution resolution = TypeResolutions.isString(e, operationName, paramOrd);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isExact(e, operationName, paramOrd);
    }

    public static Expression.TypeResolution isFoldable(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        if (!e.foldable()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be a constant, received [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == Expressions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, Expressions.name(e)}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isNotFoldable(Expression e, String operationName, Expressions.ParamOrdinal paramOrd) {
        if (e.foldable()) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be a table column, found constant [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == Expressions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, Expressions.name(e)}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public static Expression.TypeResolution isType(Expression e, Predicate<DataType> predicate, String operationName, Expressions.ParamOrdinal paramOrd, String ... acceptedTypes) {
        return predicate.test(e.dataType()) || DataTypes.isNull(e.dataType()) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{paramOrd == null || paramOrd == Expressions.ParamOrdinal.DEFAULT ? "" : paramOrd.name().toLowerCase(Locale.ROOT) + " ", operationName, TypeResolutions.acceptedTypesForErrorMsg(acceptedTypes), Expressions.name(e), e.dataType().typeName}));
    }

    private static String acceptedTypesForErrorMsg(String ... acceptedTypes) {
        StringJoiner sj = new StringJoiner(", ");
        for (int i = 0; i < acceptedTypes.length - 1; ++i) {
            sj.add(acceptedTypes[i]);
        }
        if (acceptedTypes.length > 1) {
            return sj.toString() + " or " + acceptedTypes[acceptedTypes.length - 1];
        }
        return acceptedTypes[0];
    }
}

