/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public final class Expressions {
    private Expressions() {
    }

    public static NamedExpression wrapAsNamed(Expression exp) {
        return exp instanceof NamedExpression ? (NamedExpression)exp : new Alias(exp.source(), exp.sourceText(), exp);
    }

    public static List<Attribute> asAttributes(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(named.size());
        for (NamedExpression namedExpression : named) {
            list.add(namedExpression.toAttribute());
        }
        return list;
    }

    public static AttributeMap<Expression> asAttributeMap(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return new AttributeMap<Expression>(Collections.emptyMap());
        }
        AttributeMap<Expression> map = new AttributeMap<Expression>();
        for (NamedExpression namedExpression : named) {
            map.add(namedExpression.toAttribute(), namedExpression);
        }
        return map;
    }

    public static boolean anyMatch(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!expression.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean match(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!predicate.test(expression)) continue;
            return true;
        }
        return false;
    }

    public static Nullability nullable(List<? extends Expression> exps) {
        return Nullability.and((Nullability[])exps.stream().map(Expression::nullable).toArray(Nullability[]::new));
    }

    public static boolean foldable(List<? extends Expression> exps) {
        for (Expression expression : exps) {
            if (expression.foldable()) continue;
            return false;
        }
        return true;
    }

    public static AttributeSet references(List<? extends Expression> exps) {
        if (exps.isEmpty()) {
            return AttributeSet.EMPTY;
        }
        AttributeSet set = new AttributeSet();
        for (Expression expression : exps) {
            set.addAll(expression.references());
        }
        return set;
    }

    public static AttributeSet filterReferences(Set<? extends Expression> exps, AttributeSet excluded) {
        AttributeSet ret = new AttributeSet();
        while (exps.size() > 0) {
            LinkedHashSet<Expression> filteredExps = new LinkedHashSet<Expression>();
            for (Expression expression : exps) {
                Attribute attr = Expressions.attribute(expression);
                if (attr != null && excluded.contains(attr)) continue;
                filteredExps.add(expression);
            }
            ret.addAll(new AttributeSet(filteredExps.stream().filter(c -> c.children().isEmpty()).flatMap(exp -> exp.references().stream()).collect(Collectors.toSet())));
            exps = filteredExps.stream().flatMap(exp -> exp.children().stream()).collect(Collectors.toSet());
        }
        return ret;
    }

    public static String name(Expression e) {
        return e instanceof NamedExpression ? ((NamedExpression)e).name() : e.nodeName();
    }

    public static boolean isNull(Expression e) {
        return e.dataType() == DataType.NULL || e.foldable() && e.fold() == null;
    }

    public static List<String> names(Collection<? extends Expression> e) {
        ArrayList<String> names = new ArrayList<String>(e.size());
        for (Expression expression : e) {
            names.add(Expressions.name(expression));
        }
        return names;
    }

    public static Attribute attribute(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).toAttribute();
        }
        if (e != null && e.foldable()) {
            return Literal.of(e).toAttribute();
        }
        return null;
    }

    public static boolean equalsAsAttribute(Expression left, Expression right) {
        if (!left.semanticEquals(right)) {
            Attribute l = Expressions.attribute(left);
            return l != null && l.semanticEquals(Expressions.attribute(right));
        }
        return true;
    }

    public static List<Attribute> onlyPrimitiveFieldAttributes(Collection<Attribute> attributes) {
        ArrayList<Attribute> filtered = new ArrayList<Attribute>();
        LinkedHashSet<Attribute> seenMultiFields = new LinkedHashSet<Attribute>();
        for (Attribute a : attributes) {
            if (DataTypes.isUnsupported(a.dataType()) || !a.dataType().isPrimitive()) continue;
            if (a instanceof FieldAttribute) {
                FieldAttribute fa = (FieldAttribute)a;
                if (fa.isNested() || seenMultiFields.contains(fa.parent())) continue;
                filtered.add(a);
                seenMultiFields.add(a);
                continue;
            }
            filtered.add(a);
        }
        return filtered;
    }

    public static Pipe pipe(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).asPipe();
        }
        throw new SqlIllegalArgumentException("Cannot create pipe for {}", e);
    }

    public static List<Pipe> pipe(List<Expression> expressions) {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>(expressions.size());
        for (Expression e : expressions) {
            pipes.add(Expressions.pipe(e));
        }
        return pipes;
    }

    public static enum ParamOrdinal {
        DEFAULT,
        FIRST,
        SECOND,
        THIRD,
        FOURTH;

    }
}

