/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTopHits;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class TopHitsAggExtractor
implements BucketExtractor {
    static final String NAME = "th";
    private final String name;
    private final DataType fieldDataType;
    private final ZoneId zoneId;

    public TopHitsAggExtractor(String name, DataType fieldDataType, ZoneId zoneId) {
        this.name = name;
        this.fieldDataType = fieldDataType;
        this.zoneId = zoneId;
    }

    TopHitsAggExtractor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.fieldDataType = (DataType)in.readEnum(DataType.class);
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeEnum((Enum)this.fieldDataType);
    }

    String name() {
        return this.name;
    }

    DataType fieldDataType() {
        return this.fieldDataType;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        InternalTopHits agg = (InternalTopHits)bucket.getAggregations().get(this.name);
        if (agg == null) {
            throw new SqlIllegalArgumentException("Cannot find an aggregation named {}", this.name);
        }
        if (agg.getHits().getTotalHits() == null || agg.getHits().getTotalHits().value == 0L) {
            return null;
        }
        Object value = ((DocumentField)agg.getHits().getAt(0).getFields().values().iterator().next()).getValue();
        if (this.fieldDataType.isDateBased()) {
            return DateUtils.asDateTime(Long.parseLong(value.toString()), this.zoneId);
        }
        if (this.fieldDataType.isTimeBased()) {
            return DateUtils.asTimeOnly(Long.parseLong(value.toString()), this.zoneId);
        }
        return value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.fieldDataType, this.zoneId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TopHitsAggExtractor other = (TopHitsAggExtractor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.fieldDataType, (Object)other.fieldDataType) && Objects.equals(this.zoneId, other.zoneId);
    }

    public String toString() {
        return "TopHits>" + this.name + "[" + (Object)((Object)this.fieldDataType) + "]@" + this.zoneId;
    }
}

