/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.xpack.sql.execution.search.SchemaCompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.type.Schema;

class PivotRowSet
extends SchemaCompositeAggRowSet {
    private final List<Object[]> data;
    private final Map<String, Object> lastAfterKey;

    PivotRowSet(Schema schema, List<BucketExtractor> exts, BitSet mask, SearchResponse response, int limit, Map<String, Object> previousLastKey) {
        super(schema, exts, mask, response, limit);
        ArrayList arrayList = this.data = this.buckets.isEmpty() ? Collections.emptyList() : new ArrayList();
        if (this.buckets.isEmpty()) {
            this.lastAfterKey = null;
            return;
        }
        Map currentRowGroupKey = null;
        Map lastCompletedGroupKey = null;
        Object[] currentRow = new Object[this.columnCount()];
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            CompositeAggregation.Bucket bucket = (CompositeAggregation.Bucket)this.buckets.get(bucketIndex);
            Map key = bucket.getKey();
            if (currentRowGroupKey == null || PivotRowSet.sameCompositeKey(currentRowGroupKey, key)) {
                currentRowGroupKey = key;
            } else {
                lastCompletedGroupKey = currentRowGroupKey;
                currentRowGroupKey = key;
                this.data.add(currentRow);
                if (limit > 0 && this.data.size() == limit) break;
                currentRow = new Object[this.columnCount()];
            }
            for (int columnIndex = 0; columnIndex < currentRow.length; ++columnIndex) {
                BucketExtractor extractor = (BucketExtractor)this.userExtractor(columnIndex);
                Object value = extractor.extract((MultiBucketsAggregation.Bucket)bucket);
                if (currentRow[columnIndex] != null || value == null) continue;
                currentRow[columnIndex] = value;
            }
        }
        if (limit > 0 && this.data.size() == limit) {
            this.afterKey = null;
        } else if (previousLastKey != null && PivotRowSet.sameCompositeKey(previousLastKey, currentRowGroupKey)) {
            this.data.add(currentRow);
            this.afterKey = null;
        } else if (!this.hasNull(currentRow) || this.data.isEmpty()) {
            this.data.add(currentRow);
            this.afterKey = currentRowGroupKey;
        } else {
            this.afterKey = lastCompletedGroupKey;
        }
        this.size = this.data.size();
        this.remainingData = PivotRowSet.remainingData(this.afterKey != null, this.size, limit);
        this.lastAfterKey = currentRowGroupKey;
    }

    private boolean hasNull(Object[] currentRow) {
        for (Object object : currentRow) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    static boolean sameCompositeKey(Map<String, Object> previous, Map<String, Object> current) {
        int keys = current.size() - 1;
        int keyIndex = 0;
        for (Map.Entry<String, Object> entry : current.entrySet()) {
            if (keyIndex++ >= keys) {
                return true;
            }
            if (Objects.equals(entry.getValue(), previous.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object getColumn(int column) {
        return this.data.get(this.row)[column];
    }

    Map<String, Object> lastAfterKey() {
        return this.lastAfterKey;
    }
}

