/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggCursor;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggRowSet;
import org.elasticsearch.xpack.sql.execution.search.PivotRowSet;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.type.Schema;

public class PivotCursor
extends CompositeAggCursor {
    public static final String NAME = "p";
    private final Map<String, Object> previousKey;

    PivotCursor(Map<String, Object> previousKey, byte[] next, List<BucketExtractor> exts, BitSet mask, int remainingLimit, boolean includeFrozen, String ... indices) {
        super(next, exts, mask, remainingLimit, includeFrozen, indices);
        this.previousKey = previousKey;
    }

    public PivotCursor(StreamInput in) throws IOException {
        super(in);
        this.previousKey = in.readBoolean() ? in.readMap() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.previousKey != null) {
            out.writeBoolean(true);
            out.writeMap(this.previousKey);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Supplier<CompositeAggRowSet> makeRowSet(SearchResponse response) {
        return () -> new PivotRowSet(Schema.EMPTY, this.extractors(), this.mask(), response, this.limit(), this.previousKey);
    }

    @Override
    protected BiFunction<byte[], CompositeAggRowSet, CompositeAggCursor> makeCursor() {
        return (q, r) -> {
            Map<String, Object> lastAfterKey = r instanceof PivotRowSet ? ((PivotRowSet)r).lastAfterKey() : null;
            return new PivotCursor(lastAfterKey, (byte[])q, r.extractors(), r.mask(), r.remainingData(), this.includeFrozen(), this.indices());
        };
    }

    @Override
    public String toString() {
        return "pivot for index [" + Arrays.toString(this.indices()) + "]";
    }
}

