/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.index;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DateEsField;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.type.InvalidMappedField;
import org.elasticsearch.xpack.sql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.type.TextEsField;
import org.elasticsearch.xpack.sql.type.UnsupportedEsField;
import org.elasticsearch.xpack.sql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.util.Holder;

public class IndexResolver {
    private static final IndicesOptions INDICES_ONLY_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_ALIASES, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    private static final IndicesOptions FROZEN_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_ALIASES), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions FIELD_CAPS_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_THROTTLED), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    public static final IndicesOptions FIELD_CAPS_FROZEN_INDICES_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    private static final List<String> FIELD_NAMES_BLACKLIST = Arrays.asList("_size");
    private static final String UNMAPPED = "unmapped";
    private final Client client;
    private final String clusterName;

    public IndexResolver(Client client, String clusterName) {
        this.client = client;
        this.clusterName = clusterName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void resolveNames(String indexWildcard, String javaRegex, EnumSet<IndexType> types, ActionListener<Set<IndexInfo>> listener) {
        boolean retrieveAliases = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.ALIAS);
        boolean retrieveIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.STANDARD_INDEX);
        boolean retrieveFrozenIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.FROZEN_INDEX);
        String[] indices = Strings.commaDelimitedListToStringArray((String)indexWildcard);
        if (retrieveAliases) {
            GetAliasesRequest aliasRequest = ((GetAliasesRequest)new GetAliasesRequest().local(true)).aliases(indices).indicesOptions(IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().getAliases(aliasRequest, ActionListener.wrap(aliases -> this.resolveIndices(indices, javaRegex, (GetAliasesResponse)aliases, retrieveIndices, retrieveFrozenIndices, listener), ex -> {
                if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                    this.resolveIndices(indices, javaRegex, null, retrieveIndices, retrieveFrozenIndices, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            this.resolveIndices(indices, javaRegex, null, retrieveIndices, retrieveFrozenIndices, listener);
        }
    }

    private void resolveIndices(String[] indices, String javaRegex, GetAliasesResponse aliases, boolean retrieveIndices, boolean retrieveFrozenIndices, ActionListener<Set<IndexInfo>> listener) {
        if (retrieveIndices || retrieveFrozenIndices) {
            GetIndexRequest indexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(indices)).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.SETTINGS}).includeDefaults(false).indicesOptions(INDICES_ONLY_OPTIONS);
            if (retrieveFrozenIndices) {
                indexRequest.indicesOptions(FROZEN_INDICES_OPTIONS);
            }
            this.client.admin().indices().getIndex(indexRequest, ActionListener.wrap(response -> this.filterResults(javaRegex, aliases, (GetIndexResponse)response, retrieveIndices, retrieveFrozenIndices, listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.filterResults(javaRegex, aliases, null, false, false, listener);
        }
    }

    private void filterResults(String javaRegex, GetAliasesResponse aliases, GetIndexResponse indices, boolean retrieveIndices, boolean retrieveFrozenIndices, ActionListener<Set<IndexInfo>> listener) {
        String[] indicesNames;
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<IndexInfo> result = new TreeSet<IndexInfo>(Comparator.comparing(IndexInfo::name));
        if (aliases != null) {
            for (ObjectCursor cursor : aliases.getAliases().values()) {
                for (AliasMetaData amd : (List)cursor.value) {
                    String alias = amd.alias();
                    if (alias == null || pattern != null && !pattern.matcher(alias).matches()) continue;
                    result.add(new IndexInfo(alias, IndexType.ALIAS));
                }
            }
        }
        String[] stringArray = indicesNames = indices != null ? indices.indices() : null;
        if (indicesNames != null) {
            for (String indexName : indicesNames) {
                boolean isFrozen;
                boolean bl = isFrozen = retrieveFrozenIndices && IndexSettings.INDEX_SEARCH_THROTTLED.get((Settings)indices.getSettings().get((Object)indexName)) == Boolean.TRUE;
                if (pattern != null && !pattern.matcher(indexName).matches()) continue;
                result.add(new IndexInfo(indexName, isFrozen ? IndexType.FROZEN_INDEX : IndexType.STANDARD_INDEX));
            }
        }
        listener.onResponse(result);
    }

    public void resolveAsMergedMapping(String indexWildcard, String javaRegex, boolean includeFrozen, ActionListener<IndexResolution> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, includeFrozen);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> listener.onResponse((Object)IndexResolver.mergedMappings(indexWildcard, response.getIndices(), response.get())), arg_0 -> listener.onFailure(arg_0)));
    }

    static IndexResolution mergedMappings(String indexPattern, String[] indexNames, Map<String, Map<String, FieldCapabilities>> fieldCaps) {
        if (fieldCaps == null || fieldCaps.isEmpty()) {
            return IndexResolution.notFound(indexPattern);
        }
        List<EsIndex> indices = IndexResolver.buildIndices(indexNames, null, fieldCaps, i -> indexPattern, (n, types) -> {
            StringBuilder errorMessage = new StringBuilder();
            boolean hasUnmapped = types.containsKey(UNMAPPED);
            if (types.size() > (hasUnmapped ? 2 : 1)) {
                for (Map.Entry type : types.entrySet()) {
                    if (UNMAPPED.equals(type.getKey())) continue;
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append("[");
                    errorMessage.append((String)type.getKey());
                    errorMessage.append("] in ");
                    errorMessage.append(Arrays.toString(((FieldCapabilities)type.getValue()).indices()));
                }
                errorMessage.insert(0, "mapped as [" + (types.size() - (hasUnmapped ? 1 : 0)) + "] incompatible types: ");
                return new InvalidMappedField((String)n, errorMessage.toString());
            }
            FieldCapabilities fieldCap = (FieldCapabilities)types.values().iterator().next();
            if (fieldCap.isAggregatable() && fieldCap.nonAggregatableIndices() != null) {
                errorMessage.append("mapped as aggregatable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonAggregatableIndices()));
            }
            if (fieldCap.isSearchable() && fieldCap.nonSearchableIndices() != null) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(",");
                }
                errorMessage.append("mapped as searchable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonSearchableIndices()));
            }
            if (errorMessage.length() > 0) {
                return new InvalidMappedField((String)n, errorMessage.toString());
            }
            return null;
        });
        if (indices.size() > 1) {
            throw new SqlIllegalArgumentException("Incorrect merging of mappings (likely due to a bug) - expect at most one but found [{}]", indices.size());
        }
        return IndexResolution.valid(indices.isEmpty() ? new EsIndex(indexNames[0], Collections.emptyMap()) : indices.get(0));
    }

    private static EsField createField(String fieldName, Map<String, Map<String, FieldCapabilities>> globalCaps, Map<String, EsField> hierarchicalMapping, Map<String, EsField> flattedMapping, Function<String, EsField> field) {
        Map<String, EsField> parentProps = hierarchicalMapping;
        int dot = fieldName.lastIndexOf(46);
        String fullFieldName = fieldName;
        if (dot >= 0) {
            String parentName = fieldName.substring(0, dot);
            fieldName = fieldName.substring(dot + 1);
            EsField parent = flattedMapping.get(parentName);
            if (parent == null) {
                Function<String, EsField> fieldFunction;
                Map<String, FieldCapabilities> map = globalCaps.get(parentName);
                if (map == null) {
                    fieldFunction = s -> IndexResolver.createField(s, DataType.OBJECT.name(), new TreeMap<String, EsField>(), false, true);
                } else {
                    Iterator<FieldCapabilities> iterator = map.values().iterator();
                    FieldCapabilities parentCap = iterator.next();
                    if (iterator.hasNext() && UNMAPPED.equals(parentCap.getType())) {
                        parentCap = iterator.next();
                    }
                    FieldCapabilities parentC = parentCap;
                    fieldFunction = s -> IndexResolver.createField(s, parentC.getType(), new TreeMap<String, EsField>(), parentC.isAggregatable(), false);
                }
                parent = IndexResolver.createField(parentName, globalCaps, hierarchicalMapping, flattedMapping, fieldFunction);
            }
            parentProps = parent.getProperties();
        }
        EsField esField = field.apply(fieldName);
        parentProps.put(fieldName, esField);
        flattedMapping.put(fullFieldName, esField);
        return esField;
    }

    private static EsField createField(String fieldName, String typeName, Map<String, EsField> props, boolean isAggregateable, boolean isAlias) {
        DataType esType = DataType.fromTypeName(typeName);
        switch (esType) {
            case TEXT: {
                return new TextEsField(fieldName, props, false, isAlias);
            }
            case KEYWORD: {
                int length = DataType.KEYWORD.defaultPrecision;
                boolean normalized = false;
                return new KeywordEsField(fieldName, props, isAggregateable, length, normalized, isAlias);
            }
            case DATETIME: {
                return new DateEsField(fieldName, props, isAggregateable);
            }
            case UNSUPPORTED: {
                return new UnsupportedEsField(fieldName, typeName);
            }
        }
        return new EsField(fieldName, esType, props, isAggregateable, isAlias);
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index, boolean includeFrozen) {
        return new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index)).fields(new String[]{"*"}).includeUnmapped(true).indicesOptions(includeFrozen ? FIELD_CAPS_FROZEN_INDICES_OPTIONS : FIELD_CAPS_INDICES_OPTIONS);
    }

    public void resolveAsSeparateMappings(String indexWildcard, String javaRegex, boolean includeFrozen, ActionListener<List<EsIndex>> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard, includeFrozen);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> listener.onResponse(IndexResolver.separateMappings(indexWildcard, javaRegex, response.getIndices(), response.get())), arg_0 -> listener.onFailure(arg_0)));
    }

    static List<EsIndex> separateMappings(String indexPattern, String javaRegex, String[] indexNames, Map<String, Map<String, FieldCapabilities>> fieldCaps) {
        return IndexResolver.buildIndices(indexNames, javaRegex, fieldCaps, Function.identity(), (s, cap) -> null);
    }

    private static List<EsIndex> buildIndices(String[] indexNames, String javaRegex, Map<String, Map<String, FieldCapabilities>> fieldCaps, Function<String, String> indexNameProcessor, BiFunction<String, Map<String, FieldCapabilities>, InvalidMappedField> validityVerifier) {
        if (indexNames == null || indexNames.length == 0) {
            return Collections.emptyList();
        }
        List<String> resolvedIndices = Arrays.asList(indexNames);
        LinkedHashMap<String, Fields> indices = new LinkedHashMap<String, Fields>(resolvedIndices.size());
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<Map.Entry> sortedFields = new TreeSet<Map.Entry>(Collections.reverseOrder(Comparator.comparing(Map.Entry::getKey)));
        sortedFields.addAll(fieldCaps.entrySet());
        for (Map.Entry entry : sortedFields) {
            String fieldName = (String)entry.getKey();
            Map types = (Map)entry.getValue();
            if (FIELD_NAMES_BLACKLIST.contains(fieldName)) continue;
            InvalidMappedField invalidField = validityVerifier.apply(fieldName, types);
            FieldCapabilities unmapped = (FieldCapabilities)types.get(UNMAPPED);
            HashSet<String> unmappedIndices = unmapped != null ? new HashSet<String>(Arrays.asList(unmapped.indices())) : Collections.emptySet();
            for (Map.Entry typeEntry : types.entrySet()) {
                FieldCapabilities typeCap = (FieldCapabilities)typeEntry.getValue();
                String[] capIndices = typeCap.indices();
                if (((String)typeEntry.getKey()).startsWith("_") && typeCap.getType().startsWith("_")) continue;
                List<String> concreteIndices = null;
                if (capIndices != null) {
                    if (unmappedIndices.isEmpty()) {
                        concreteIndices = Arrays.asList(capIndices);
                    } else {
                        concreteIndices = new ArrayList<String>(capIndices.length);
                        for (String capIndex : capIndices) {
                            if (unmappedIndices.contains(capIndex)) continue;
                            concreteIndices.add(capIndex);
                        }
                    }
                } else {
                    concreteIndices = resolvedIndices;
                }
                for (String index : concreteIndices) {
                    String parentName;
                    EsField field;
                    if (pattern != null && !pattern.matcher(index).matches()) continue;
                    String indexName = indexNameProcessor.apply(index);
                    Fields indexFields = (Fields)indices.get(indexName);
                    if (indexFields == null) {
                        indexFields = new Fields();
                        indices.put(indexName, indexFields);
                    }
                    if ((field = indexFields.flattedMapping.get(fieldName)) != null && (invalidField == null || field instanceof InvalidMappedField)) continue;
                    int dot = fieldName.lastIndexOf(46);
                    Holder<Boolean> isAlias = new Holder<Boolean>(false);
                    if (dot >= 0 && indexFields.flattedMapping.get(parentName = fieldName.substring(0, dot)) == null && fieldCaps.get(parentName) == null) {
                        isAlias.set(true);
                    }
                    IndexResolver.createField(fieldName, fieldCaps, indexFields.hierarchicalMapping, indexFields.flattedMapping, s -> invalidField != null ? invalidField : IndexResolver.createField(s, typeCap.getType(), Collections.emptyMap(), typeCap.isAggregatable(), (Boolean)isAlias.get()));
                }
            }
        }
        ArrayList<EsIndex> foundIndices = new ArrayList<EsIndex>(indices.size());
        for (Map.Entry entry : indices.entrySet()) {
            foundIndices.add(new EsIndex((String)entry.getKey(), ((Fields)entry.getValue()).hierarchicalMapping));
        }
        foundIndices.sort(Comparator.comparing(EsIndex::name));
        return foundIndices;
    }

    private static class Fields {
        final Map<String, EsField> hierarchicalMapping = new TreeMap<String, EsField>();
        final Map<String, EsField> flattedMapping = new LinkedHashMap<String, EsField>();

        private Fields() {
        }
    }

    public static class IndexInfo {
        private final String name;
        private final IndexType type;

        public IndexInfo(String name, IndexType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public IndexType type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IndexInfo other = (IndexInfo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }
    }

    public static enum IndexType {
        STANDARD_INDEX("BASE TABLE", "INDEX"),
        ALIAS("VIEW", "ALIAS"),
        FROZEN_INDEX("BASE TABLE", "FROZEN INDEX"),
        UNKNOWN("UNKNOWN", "UNKNOWN");

        public static final String SQL_BASE_TABLE = "BASE TABLE";
        public static final String SQL_TABLE = "TABLE";
        public static final String SQL_VIEW = "VIEW";
        public static final EnumSet<IndexType> VALID_INCLUDE_FROZEN;
        public static final EnumSet<IndexType> VALID_REGULAR;
        public static final EnumSet<IndexType> INDICES_ONLY;
        private final String toSql;
        private final String toNative;

        private IndexType(String sql, String toNative) {
            this.toSql = sql;
            this.toNative = toNative;
        }

        public String toSql() {
            return this.toSql;
        }

        public String toNative() {
            return this.toNative;
        }

        static {
            VALID_INCLUDE_FROZEN = EnumSet.of(STANDARD_INDEX, ALIAS, FROZEN_INDEX);
            VALID_REGULAR = EnumSet.of(STANDARD_INDEX, ALIAS);
            INDICES_ONLY = EnumSet.of(STANDARD_INDEX, FROZEN_INDEX);
        }
    }
}

