/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.xpack.core.security.transport.SSLExceptionHelper;

public final class SecurityHttpExceptionHandler
implements BiConsumer<HttpChannel, Exception> {
    private final Lifecycle lifecycle;
    private final Logger logger;
    private final BiConsumer<HttpChannel, Exception> fallback;

    public SecurityHttpExceptionHandler(Logger logger, Lifecycle lifecycle, BiConsumer<HttpChannel, Exception> fallback) {
        this.lifecycle = lifecycle;
        this.logger = logger;
        this.fallback = fallback;
    }

    @Override
    public void accept(HttpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (SSLExceptionHelper.isNotSslRecordException((Throwable)e)) {
            this.logger.warn("received plaintext http traffic on an https channel, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException((Throwable)e)) {
            this.logger.debug("connection {} closed during ssl handshake", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException((Throwable)e)) {
            this.logger.warn("http client did not trust this server's certificate, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else {
            this.fallback.accept(channel, e);
        }
    }
}

