/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authz.IndicesAndAliasesResolver;
import org.elasticsearch.xpack.security.authz.RBACEngine;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class AuthorizationService {
    public static final Setting<Boolean> ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"authc.anonymous.authz_exception"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String ORIGINATING_ACTION_KEY = "_originating_action_name";
    public static final String AUTHORIZATION_INFO_KEY = "_authz_info";
    private static final AuthorizationEngine.AuthorizationInfo SYSTEM_AUTHZ_INFO = () -> Collections.singletonMap("user.roles", new String[]{"_system"});
    private static final String IMPLIED_INDEX_ACTION = "indices:data/write/index:op_type/index";
    private static final String IMPLIED_CREATE_ACTION = "indices:data/write/index:op_type/create";
    private static final Logger logger = LogManager.getLogger(AuthorizationService.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final AuditTrailService auditTrail;
    private final IndicesAndAliasesResolver indicesAndAliasesResolver;
    private final AuthenticationFailureHandler authcFailureHandler;
    private final ThreadContext threadContext;
    private final AnonymousUser anonymousUser;
    private final AuthorizationEngine rbacEngine;
    private final AuthorizationEngine authorizationEngine;
    private final Set<RequestInterceptor> requestInterceptors;
    private final XPackLicenseState licenseState;
    private final boolean isAnonymousEnabled;
    private final boolean anonymousAuthzExceptionEnabled;

    public AuthorizationService(Settings settings, CompositeRolesStore rolesStore, ClusterService clusterService, AuditTrailService auditTrail, AuthenticationFailureHandler authcFailureHandler, ThreadPool threadPool, AnonymousUser anonymousUser, @Nullable AuthorizationEngine authorizationEngine, Set<RequestInterceptor> requestInterceptors, XPackLicenseState licenseState) {
        this.clusterService = clusterService;
        this.auditTrail = auditTrail;
        this.indicesAndAliasesResolver = new IndicesAndAliasesResolver(settings, clusterService);
        this.authcFailureHandler = authcFailureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.isAnonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.anonymousAuthzExceptionEnabled = (Boolean)ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING.get(settings);
        this.rbacEngine = new RBACEngine(settings, rolesStore);
        this.authorizationEngine = authorizationEngine == null ? this.rbacEngine : authorizationEngine;
        this.requestInterceptors = requestInterceptors;
        this.settings = settings;
        this.licenseState = licenseState;
    }

    public void checkPrivileges(Authentication authentication, HasPrivilegesRequest request, Collection<ApplicationPrivilegeDescriptor> applicationPrivilegeDescriptors, ActionListener<HasPrivilegesResponse> listener) {
        this.getAuthorizationEngine(authentication).checkPrivileges(authentication, this.getAuthorizationInfoFromContext(), request, applicationPrivilegeDescriptors, (ActionListener)ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadContext));
    }

    public void retrieveUserPrivileges(Authentication authentication, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        this.getAuthorizationEngine(authentication).getUserPrivileges(authentication, this.getAuthorizationInfoFromContext(), request, listener);
    }

    private AuthorizationEngine.AuthorizationInfo getAuthorizationInfoFromContext() {
        return Objects.requireNonNull((AuthorizationEngine.AuthorizationInfo)this.threadContext.getTransient(AUTHORIZATION_INFO_KEY), "authorization info is missing from context");
    }

    public void authorize(Authentication authentication, String action, TransportRequest originalRequest, ActionListener<Void> listener) throws ElasticsearchSecurityException {
        this.putTransientIfNonExisting(ORIGINATING_ACTION_KEY, action);
        String auditId = AuditUtil.extractRequestId(this.threadContext);
        if (auditId == null) {
            if (this.isInternalUser(authentication.getUser())) {
                auditId = AuditUtil.getOrGenerateRequestId(this.threadContext);
            } else {
                this.auditTrail.tamperedRequest(null, authentication.getUser(), action, (TransportMessage)originalRequest);
                String message = "Attempt to authorize action [" + action + "] for [" + authentication.getUser().principal() + "] without an existing request-id";
                assert (false) : message;
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException(message, new Object[0])));
            }
        }
        TransportRequest unwrappedRequest = this.maybeUnwrapRequest(authentication, originalRequest, action, auditId);
        if (SystemUser.is((User)authentication.getUser())) {
            this.authorizeSystemUser(authentication, action, auditId, unwrappedRequest, listener);
        } else {
            String finalAuditId = auditId;
            AuthorizationEngine.RequestInfo requestInfo = new AuthorizationEngine.RequestInfo(authentication, unwrappedRequest, action);
            ContextPreservingActionListener authzInfoListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(authorizationInfo -> {
                this.putTransientIfNonExisting(AUTHORIZATION_INFO_KEY, authorizationInfo);
                this.maybeAuthorizeRunAs(requestInfo, finalAuditId, (AuthorizationEngine.AuthorizationInfo)authorizationInfo, listener);
            }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext);
            this.getAuthorizationEngine(authentication).resolveAuthorizationInfo(requestInfo, (ActionListener)authzInfoListener);
        }
    }

    private void maybeAuthorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        boolean isRunAs = authentication.getUser().isRunAs();
        if (isRunAs) {
            ContextPreservingActionListener runAsListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(result -> {
                if (result.isGranted()) {
                    if (result.isAuditable()) {
                        this.auditTrail.runAsGranted(requestId, authentication, action, (TransportMessage)request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                    }
                    this.authorizeAction(requestInfo, requestId, authzInfo, listener);
                } else {
                    if (result.isAuditable()) {
                        this.auditTrail.runAsDenied(requestId, authentication, action, (TransportMessage)request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                    }
                    listener.onFailure((Exception)((Object)this.denialException(authentication, action, null)));
                }
            }, e -> {
                this.auditTrail.runAsDenied(requestId, authentication, action, (TransportMessage)request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                listener.onFailure((Exception)((Object)this.denialException(authentication, action, null)));
            }), (ThreadContext)this.threadContext);
            this.authorizeRunAs(requestInfo, authzInfo, (ActionListener<AuthorizationEngine.AuthorizationResult>)runAsListener);
        } else {
            this.authorizeAction(requestInfo, requestId, authzInfo, listener);
        }
    }

    private void authorizeAction(AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        AuthorizationEngine authzEngine = this.getAuthorizationEngine(authentication);
        if (ClusterPrivilegeResolver.isClusterAction((String)action)) {
            ContextPreservingActionListener clusterAuthzListener = ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(result -> {
                this.putTransientIfNonExisting("_indices_permissions", IndicesAccessControl.ALLOW_ALL);
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0), requestInfo, requestId, authzInfo), (ThreadContext)this.threadContext);
            authzEngine.authorizeClusterAction(requestInfo, authzInfo, (ActionListener)clusterAuthzListener);
        } else if (IndexPrivilege.ACTION_MATCHER.test(action)) {
            MetaData metaData = this.clusterService.state().metaData();
            CachingAsyncSupplier authorizedIndicesSupplier = new CachingAsyncSupplier(authzIndicesListener -> authzEngine.loadAuthorizedIndices(requestInfo, authzInfo, (Map)metaData.getAliasAndIndexLookup(), authzIndicesListener));
            CachingAsyncSupplier resolvedIndicesAsyncSupplier = new CachingAsyncSupplier(resolvedIndicesListener -> authorizedIndicesSupplier.getAsync(ActionListener.wrap(authorizedIndices -> this.resolveIndexNames(request, metaData, (List<String>)authorizedIndices, (ActionListener<ResolvedIndices>)resolvedIndicesListener), e -> {
                this.auditTrail.accessDenied(requestId, authentication, action, (TransportMessage)request, authzInfo);
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure(e);
                } else {
                    listener.onFailure((Exception)((Object)this.denialException(authentication, action, (Exception)e)));
                }
            })));
            authzEngine.authorizeIndexAction(requestInfo, authzInfo, resolvedIndicesAsyncSupplier, (Map)metaData.getAliasAndIndexLookup(), (ActionListener)ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(result -> this.handleIndexActionAuthorizationResult((AuthorizationEngine.IndexAuthorizationResult)result, requestInfo, requestId, authzInfo, authzEngine, authorizedIndicesSupplier, resolvedIndicesAsyncSupplier, metaData, listener), arg_0 -> listener.onFailure(arg_0), requestInfo, requestId, authzInfo), (ThreadContext)this.threadContext));
        } else {
            logger.warn("denying access as action [{}] is not an index or cluster action", (Object)action);
            this.auditTrail.accessDenied(requestId, authentication, action, (TransportMessage)request, authzInfo);
            listener.onFailure((Exception)((Object)this.denialException(authentication, action, null)));
        }
    }

    private void handleIndexActionAuthorizationResult(AuthorizationEngine.IndexAuthorizationResult result, AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, AuthorizationEngine authzEngine, AuthorizationEngine.AsyncSupplier<List<String>> authorizedIndicesSupplier, AuthorizationEngine.AsyncSupplier<ResolvedIndices> resolvedIndicesAsyncSupplier, MetaData metaData, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        if (result.getIndicesAccessControl() != null) {
            this.putTransientIfNonExisting("_indices_permissions", result.getIndicesAccessControl());
        }
        if (IndexPrivilege.CREATE_INDEX_MATCHER.test(action)) {
            assert (request instanceof CreateIndexRequest);
            Set aliases = ((CreateIndexRequest)request).aliases();
            if (aliases.isEmpty()) {
                this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener);
            } else {
                AuthorizationEngine.RequestInfo aliasesRequestInfo = new AuthorizationEngine.RequestInfo(authentication, request, "indices:admin/aliases");
                authzEngine.authorizeIndexAction(aliasesRequestInfo, authzInfo, ril -> resolvedIndicesAsyncSupplier.getAsync(ActionListener.wrap(resolvedIndices -> {
                    ArrayList<String> aliasesAndIndices = new ArrayList<String>(resolvedIndices.getLocal());
                    for (Alias alias : aliases) {
                        aliasesAndIndices.add(alias.name());
                    }
                    ResolvedIndices withAliases = new ResolvedIndices(aliasesAndIndices, Collections.emptyList());
                    ril.onResponse((Object)withAliases);
                }, arg_0 -> ((ActionListener)ril).onFailure(arg_0))), (Map)metaData.getAliasAndIndexLookup(), (ActionListener)ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(authorizationResult -> this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener), arg_0 -> listener.onFailure(arg_0), aliasesRequestInfo, requestId, authzInfo), (ThreadContext)this.threadContext));
            }
        } else if (action.equals("indices:data/write/bulk[s]")) {
            assert (request instanceof BulkShardRequest) : "Action " + action + " requires " + BulkShardRequest.class + " but was " + request.getClass();
            this.authorizeBulkItems(requestInfo, authzInfo, authzEngine, resolvedIndicesAsyncSupplier, authorizedIndicesSupplier, metaData, requestId, (ActionListener<Void>)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(ignore -> this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener), arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext));
        } else {
            this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener);
        }
    }

    private void runRequestInterceptors(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authorizationInfo, AuthorizationEngine authorizationEngine, ActionListener<Void> listener) {
        if (this.requestInterceptors.isEmpty()) {
            listener.onResponse(null);
        } else {
            Iterator<RequestInterceptor> requestInterceptorIterator = this.requestInterceptors.iterator();
            StepListener firstStepListener = new StepListener();
            RequestInterceptor first = requestInterceptorIterator.next();
            StepListener prevListener = firstStepListener;
            while (requestInterceptorIterator.hasNext()) {
                RequestInterceptor nextInterceptor = requestInterceptorIterator.next();
                StepListener current = new StepListener();
                prevListener.whenComplete(v -> nextInterceptor.intercept(requestInfo, authorizationEngine, authorizationInfo, (ActionListener<Void>)current), arg_0 -> listener.onFailure(arg_0));
                prevListener = current;
            }
            prevListener.whenComplete(v -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0));
            first.intercept(requestInfo, authorizationEngine, authorizationInfo, (ActionListener<Void>)firstStepListener);
        }
    }

    AuthorizationEngine getRunAsAuthorizationEngine(Authentication authentication) {
        return this.getAuthorizationEngineForUser(authentication.getUser().authenticatedUser());
    }

    AuthorizationEngine getAuthorizationEngine(Authentication authentication) {
        return this.getAuthorizationEngineForUser(authentication.getUser());
    }

    private AuthorizationEngine getAuthorizationEngineForUser(User user) {
        if (this.rbacEngine != this.authorizationEngine && this.licenseState.isAuthorizationEngineAllowed()) {
            if (ClientReservedRealm.isReserved((String)user.principal(), (Settings)this.settings) || this.isInternalUser(user)) {
                return this.rbacEngine;
            }
            return this.authorizationEngine;
        }
        return this.rbacEngine;
    }

    private void authorizeSystemUser(Authentication authentication, String action, String requestId, TransportRequest request, ActionListener<Void> listener) {
        if (SystemUser.isAuthorized((String)action)) {
            this.putTransientIfNonExisting("_indices_permissions", IndicesAccessControl.ALLOW_ALL);
            this.putTransientIfNonExisting(AUTHORIZATION_INFO_KEY, SYSTEM_AUTHZ_INFO);
            this.auditTrail.accessGranted(requestId, authentication, action, (TransportMessage)request, SYSTEM_AUTHZ_INFO);
            listener.onResponse(null);
        } else {
            this.auditTrail.accessDenied(requestId, authentication, action, (TransportMessage)request, SYSTEM_AUTHZ_INFO);
            listener.onFailure((Exception)((Object)this.denialException(authentication, action, null)));
        }
    }

    private TransportRequest maybeUnwrapRequest(Authentication authentication, TransportRequest originalRequest, String action, String requestId) {
        TransportRequest request;
        if (originalRequest instanceof TransportReplicationAction.ConcreteShardRequest) {
            request = ((TransportReplicationAction.ConcreteShardRequest)originalRequest).getRequest();
            assert (!TransportActionProxy.isProxyRequest((TransportRequest)request)) : "expected non-proxy request for action: " + action;
        } else {
            request = TransportActionProxy.unwrapRequest((TransportRequest)originalRequest);
            boolean isOriginalRequestProxyRequest = TransportActionProxy.isProxyRequest((TransportRequest)originalRequest);
            boolean isProxyAction = TransportActionProxy.isProxyAction((String)action);
            if (isProxyAction && !isOriginalRequestProxyRequest) {
                IllegalStateException cause = new IllegalStateException("originalRequest is not a proxy request: [" + originalRequest + "] but action: [" + action + "] is a proxy action");
                this.auditTrail.accessDenied(requestId, authentication, action, (TransportMessage)request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
                throw this.denialException(authentication, action, cause);
            }
            if (TransportActionProxy.isProxyRequest((TransportRequest)originalRequest) && !TransportActionProxy.isProxyAction((String)action)) {
                IllegalStateException cause = new IllegalStateException("originalRequest is a proxy request for: [" + request + "] but action: [" + action + "] isn't");
                this.auditTrail.accessDenied(requestId, authentication, action, (TransportMessage)request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
                throw this.denialException(authentication, action, cause);
            }
        }
        return request;
    }

    private boolean isInternalUser(User user) {
        return SystemUser.is((User)user) || XPackUser.is((User)user) || XPackSecurityUser.is((User)user);
    }

    private void authorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        if (authentication.getLookedUpBy() == null) {
            listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
        } else {
            AuthorizationEngine runAsAuthzEngine = this.getRunAsAuthorizationEngine(authentication);
            runAsAuthzEngine.authorizeRunAs(requestInfo, authzInfo, listener);
        }
    }

    private void authorizeBulkItems(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authzInfo, AuthorizationEngine authzEngine, AuthorizationEngine.AsyncSupplier<ResolvedIndices> resolvedIndicesAsyncSupplier, AuthorizationEngine.AsyncSupplier<List<String>> authorizedIndicesSupplier, MetaData metaData, String requestId, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        BulkShardRequest request = (BulkShardRequest)requestInfo.getRequest();
        HashMap resolvedIndexNames = new HashMap();
        HashMap actionToIndicesMap = new HashMap();
        authorizedIndicesSupplier.getAsync(ActionListener.wrap(authorizedIndices -> resolvedIndicesAsyncSupplier.getAsync(ActionListener.wrap(overallResolvedIndices -> {
            HashSet localIndices = new HashSet(overallResolvedIndices.getLocal());
            for (BulkItemRequest item : request.items()) {
                String resolvedIndex = resolvedIndexNames.computeIfAbsent(item.index(), key -> {
                    ResolvedIndices resolvedIndices = this.indicesAndAliasesResolver.resolveIndicesAndAliases((IndicesRequest)item.request(), metaData, (List<String>)authorizedIndices);
                    if (resolvedIndices.getRemote().size() != 0) {
                        throw AuthorizationService.illegalArgument("Bulk item should not write to remote indices, but request writes to " + String.join((CharSequence)",", resolvedIndices.getRemote()));
                    }
                    if (resolvedIndices.getLocal().size() != 1) {
                        throw AuthorizationService.illegalArgument("Bulk item should write to exactly 1 index, but request writes to " + String.join((CharSequence)",", resolvedIndices.getLocal()));
                    }
                    String resolved = (String)resolvedIndices.getLocal().get(0);
                    if (!localIndices.contains(resolved)) {
                        throw AuthorizationService.illegalArgument("Found bulk item that writes to index " + resolved + " but the request writes to " + localIndices);
                    }
                    return resolved;
                });
                String itemAction = AuthorizationService.getAction(item);
                actionToIndicesMap.compute(itemAction, (key, resolvedIndicesSet) -> {
                    Set localSet = resolvedIndicesSet != null ? resolvedIndicesSet : new HashSet();
                    localSet.add(resolvedIndex);
                    return localSet;
                });
            }
            ActionListener bulkAuthzListener = ActionListener.wrap(collection -> {
                HashMap actionToIndicesAccessControl = new HashMap();
                AtomicBoolean audit = new AtomicBoolean(false);
                collection.forEach(tuple -> {
                    IndicesAccessControl existing = actionToIndicesAccessControl.putIfAbsent((String)tuple.v1(), ((AuthorizationEngine.IndexAuthorizationResult)tuple.v2()).getIndicesAccessControl());
                    if (existing != null) {
                        throw new IllegalStateException("a value already exists for action " + (String)tuple.v1());
                    }
                    if (((AuthorizationEngine.IndexAuthorizationResult)tuple.v2()).isAuditable()) {
                        audit.set(true);
                    }
                });
                for (BulkItemRequest item : request.items()) {
                    String resolvedIndex = (String)resolvedIndexNames.get(item.index());
                    String itemAction = AuthorizationService.getAction(item);
                    IndicesAccessControl indicesAccessControl = (IndicesAccessControl)actionToIndicesAccessControl.get(itemAction);
                    IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(resolvedIndex);
                    if (indexAccessControl == null || !indexAccessControl.isGranted()) {
                        this.auditTrail.explicitIndexAccessEvent(requestId, AuditLevel.ACCESS_DENIED, authentication, itemAction, resolvedIndex, item.getClass().getSimpleName(), request.remoteAddress(), authzInfo);
                        item.abort(resolvedIndex, (Exception)((Object)this.denialException(authentication, itemAction, null)));
                        continue;
                    }
                    if (!audit.get()) continue;
                    this.auditTrail.explicitIndexAccessEvent(requestId, AuditLevel.ACCESS_GRANTED, authentication, itemAction, resolvedIndex, item.getClass().getSimpleName(), request.remoteAddress(), authzInfo);
                }
                listener.onResponse(null);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            ContextPreservingActionListener groupedActionListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)new GroupedActionListener(bulkAuthzListener, actionToIndicesMap.size()), (ThreadContext)this.threadContext);
            actionToIndicesMap.forEach((arg_0, arg_1) -> AuthorizationService.lambda$authorizeBulkItems$22(requestInfo, authzEngine, authzInfo, metaData, (ActionListener)groupedActionListener, arg_0, arg_1));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private static IllegalArgumentException illegalArgument(String message) {
        assert (false) : message;
        return new IllegalArgumentException(message);
    }

    private static String getAction(BulkItemRequest item) {
        DocWriteRequest docWriteRequest = item.request();
        switch (docWriteRequest.opType()) {
            case INDEX: {
                return IMPLIED_INDEX_ACTION;
            }
            case CREATE: {
                return IMPLIED_CREATE_ACTION;
            }
            case UPDATE: {
                return "indices:data/write/update";
            }
            case DELETE: {
                return "indices:data/write/delete";
            }
        }
        throw new IllegalArgumentException("No equivalent action for opType [" + docWriteRequest.opType() + "]");
    }

    private void resolveIndexNames(TransportRequest request, MetaData metaData, List<String> authorizedIndices, ActionListener<ResolvedIndices> listener) {
        listener.onResponse((Object)this.indicesAndAliasesResolver.resolve(request, metaData, authorizedIndices));
    }

    private void putTransientIfNonExisting(String key, Object value) {
        Object existing = this.threadContext.getTransient(key);
        if (existing == null) {
            this.threadContext.putTransient(key, value);
        }
    }

    private ElasticsearchSecurityException denialException(Authentication authentication, String action, Exception cause) {
        User authUser = authentication.getUser().authenticatedUser();
        if (this.isAnonymousEnabled && this.anonymousUser.equals((Object)authUser) && !this.anonymousAuthzExceptionEnabled) {
            return this.authcFailureHandler.authenticationRequired(action, this.threadContext);
        }
        if (authentication.getUser().isRunAs()) {
            logger.debug("action [{}] is unauthorized for user [{}] run as [{}]", (Object)action, (Object)authUser.principal(), (Object)authentication.getUser().principal());
            return Exceptions.authorizationError((String)"action [{}] is unauthorized for user [{}] run as [{}]", (Exception)cause, (Object[])new Object[]{action, authUser.principal(), authentication.getUser().principal()});
        }
        if (authentication.getAuthenticatedBy().getType().equals("_es_api_key")) {
            String apiKeyId = (String)authentication.getMetadata().get("_security_api_key_id");
            assert (apiKeyId != null) : "api key id must be present in the metadata";
            logger.debug("action [{}] is unauthorized for API key id [{}] of user [{}]", (Object)action, (Object)apiKeyId, (Object)authUser.principal());
            return Exceptions.authorizationError((String)"action [{}] is unauthorized for API key id [{}] of user [{}]", (Exception)cause, (Object[])new Object[]{action, apiKeyId, authUser.principal()});
        }
        logger.debug("action [{}] is unauthorized for user [{}]", (Object)action, (Object)authUser.principal());
        return Exceptions.authorizationError((String)"action [{}] is unauthorized for user [{}]", (Exception)cause, (Object[])new Object[]{action, authUser.principal()});
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING);
    }

    private static /* synthetic */ void lambda$authorizeBulkItems$22(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authzEngine, AuthorizationEngine.AuthorizationInfo authzInfo, MetaData metaData, ActionListener groupedActionListener, String bulkItemAction, Set indices) {
        AuthorizationEngine.RequestInfo bulkItemInfo = new AuthorizationEngine.RequestInfo(requestInfo.getAuthentication(), requestInfo.getRequest(), bulkItemAction);
        authzEngine.authorizeIndexAction(bulkItemInfo, authzInfo, ril -> ril.onResponse((Object)new ResolvedIndices(new ArrayList(indices), Collections.emptyList())), (Map)metaData.getAliasAndIndexLookup(), ActionListener.wrap(indexAuthorizationResult -> groupedActionListener.onResponse((Object)new Tuple((Object)bulkItemAction, indexAuthorizationResult)), arg_0 -> ((ActionListener)groupedActionListener).onFailure(arg_0)));
    }

    private static class CachingAsyncSupplier<V>
    implements AuthorizationEngine.AsyncSupplier<V> {
        private final AuthorizationEngine.AsyncSupplier<V> asyncSupplier;
        private V value = null;

        private CachingAsyncSupplier(AuthorizationEngine.AsyncSupplier<V> supplier) {
            this.asyncSupplier = supplier;
        }

        public synchronized void getAsync(ActionListener<V> listener) {
            if (this.value == null) {
                this.asyncSupplier.getAsync(ActionListener.wrap(loaded -> {
                    this.value = loaded;
                    listener.onResponse(this.value);
                }, arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onResponse(this.value);
            }
        }
    }

    private class AuthorizationResultListener<T extends AuthorizationEngine.AuthorizationResult>
    implements ActionListener<T> {
        private final Consumer<T> responseConsumer;
        private final Consumer<Exception> failureConsumer;
        private final AuthorizationEngine.RequestInfo requestInfo;
        private final String requestId;
        private final AuthorizationEngine.AuthorizationInfo authzInfo;

        private AuthorizationResultListener(Consumer<T> responseConsumer, Consumer<Exception> failureConsumer, AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo) {
            this.responseConsumer = responseConsumer;
            this.failureConsumer = failureConsumer;
            this.requestInfo = requestInfo;
            this.requestId = requestId;
            this.authzInfo = authzInfo;
        }

        public void onResponse(T result) {
            if (result.isGranted()) {
                if (result.isAuditable()) {
                    AuthorizationService.this.auditTrail.accessGranted(this.requestId, this.requestInfo.getAuthentication(), this.requestInfo.getAction(), (TransportMessage)this.requestInfo.getRequest(), this.authzInfo);
                }
                try {
                    this.responseConsumer.accept(result);
                }
                catch (Exception e) {
                    this.failureConsumer.accept(e);
                }
            } else {
                this.handleFailure(result.isAuditable(), null);
            }
        }

        public void onFailure(Exception e) {
            this.handleFailure(true, e);
        }

        private void handleFailure(boolean audit, @Nullable Exception e) {
            if (audit) {
                AuthorizationService.this.auditTrail.accessDenied(this.requestId, this.requestInfo.getAuthentication(), this.requestInfo.getAction(), (TransportMessage)this.requestInfo.getRequest(), this.authzInfo);
            }
            this.failureConsumer.accept((Exception)((Object)AuthorizationService.this.denialException(this.requestInfo.getAuthentication(), this.requestInfo.getAction(), e)));
        }
    }
}

