/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.Closeable;
import java.util.stream.Stream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.CharArrays;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.LdapUserSearchSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class LdapUserSearchSessionFactory
extends PoolingSessionFactory {
    static final String SEARCH_PREFIX = "user_search.";
    private final String userSearchBaseDn;
    private final LdapSearchScope scope;
    private final String searchFilter;

    LdapUserSearchSessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, LdapUserSearchSessionFactory.groupResolver(config), (Setting.AffixSetting<Boolean>)LdapUserSearchSessionFactorySettings.POOL_ENABLED, (String)config.getSetting(PoolingSessionFactorySettings.BIND_DN, () -> null), () -> (String)config.getSetting(PoolingSessionFactorySettings.BIND_DN, () -> (String)config.getSetting(LdapUserSearchSessionFactorySettings.SEARCH_BASE_DN)), threadPool);
        this.userSearchBaseDn = (String)config.getSetting(LdapUserSearchSessionFactorySettings.SEARCH_BASE_DN, () -> {
            throw new IllegalArgumentException("[" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapUserSearchSessionFactorySettings.SEARCH_BASE_DN) + "] must be specified");
        });
        this.scope = (LdapSearchScope)config.getSetting(LdapUserSearchSessionFactorySettings.SEARCH_SCOPE);
        this.searchFilter = LdapUserSearchSessionFactory.getSearchFilter(config);
        this.logger.info("Realm [{}] is in user-search mode - base_dn=[{}], search filter=[{}]", (Object)config.name(), (Object)this.userSearchBaseDn, (Object)this.searchFilter);
    }

    static boolean hasUserSearchSettings(RealmConfig config) {
        return Stream.of(LdapUserSearchSessionFactorySettings.SEARCH_BASE_DN, LdapUserSearchSessionFactorySettings.SEARCH_ATTRIBUTE, LdapUserSearchSessionFactorySettings.SEARCH_SCOPE, LdapUserSearchSessionFactorySettings.SEARCH_FILTER, LdapUserSearchSessionFactorySettings.POOL_ENABLED).anyMatch(arg_0 -> ((RealmConfig)config).hasSetting(arg_0));
    }

    @Override
    void getSessionWithPool(LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
                SimpleBindRequest bind = new SimpleBindRequest(dn, passwordBytes);
                LdapUtils.maybeForkThenBindAndRevert(connectionPool, (BindRequest)bind, this.threadPool, (AbstractRunnable)ActionRunnable.supply((ActionListener)listener, () -> new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes())));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getSessionWithoutPool(final String user, final SecureString password, final ActionListener<LdapSession> listener) {
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            LdapUtils.maybeForkThenBind(connection, (BindRequest)this.bindCredentials, this.threadPool, new AbstractRunnable(){

                protected void doRun() throws Exception {
                    LdapUserSearchSessionFactory.this.findUser(user, (LDAPInterface)connection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable[])new Closeable[]{connection});
                            listener.onResponse(null);
                        } else {
                            final String dn = entry.getDN();
                            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])password.getChars());
                            SimpleBindRequest userBind = new SimpleBindRequest(dn, passwordBytes);
                            LdapUtils.maybeForkThenBind(connection, (BindRequest)userBind, LdapUserSearchSessionFactory.this.threadPool, new AbstractRunnable((SearchResultEntry)entry){
                                final /* synthetic */ SearchResultEntry val$entry;
                                {
                                    this.val$entry = searchResultEntry;
                                }

                                protected void doRun() throws Exception {
                                    LdapUtils.maybeForkThenBind(connection, (BindRequest)LdapUserSearchSessionFactory.this.bindCredentials, LdapUserSearchSessionFactory.this.threadPool, new AbstractRunnable(){

                                        protected void doRun() throws Exception {
                                            listener.onResponse((Object)new LdapSession(LdapUserSearchSessionFactory.this.logger, LdapUserSearchSessionFactory.this.config, (LDAPInterface)connection, dn, LdapUserSearchSessionFactory.this.groupResolver, LdapUserSearchSessionFactory.this.metaDataResolver, LdapUserSearchSessionFactory.this.timeout, val$entry.getAttributes()));
                                        }

                                        public void onFailure(Exception e) {
                                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                                            listener.onFailure(e);
                                        }
                                    });
                                }

                                public void onFailure(Exception e) {
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                                    listener.onFailure(e);
                                }
                            });
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }));
                }

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                LdapSession session = new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes());
                listener.onResponse((Object)session);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getUnauthenticatedSessionWithoutPool(final String user, final ActionListener<LdapSession> listener) {
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            LdapUtils.maybeForkThenBind(connection, (BindRequest)this.bindCredentials, this.threadPool, new AbstractRunnable(){

                protected void doRun() throws Exception {
                    LdapUserSearchSessionFactory.this.findUser(user, (LDAPInterface)connection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable[])new Closeable[]{connection});
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)new LdapSession(LdapUserSearchSessionFactory.this.logger, LdapUserSearchSessionFactory.this.config, (LDAPInterface)connection, entry.getDN(), LdapUserSearchSessionFactory.this.groupResolver, LdapUserSearchSessionFactory.this.metaDataResolver, LdapUserSearchSessionFactory.this.timeout, entry.getAttributes()));
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }));
                }

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    private void findUser(String user, LDAPInterface ldapInterface, ActionListener<SearchResultEntry> listener) {
        Filter filter;
        try {
            filter = LdapUtils.createFilter(this.searchFilter, user);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        LdapUtils.searchForEntry(ldapInterface, this.userSearchBaseDn, this.scope.scope(), filter, Math.toIntExact(this.timeout.seconds()), this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupResolver.attributes(), this.metaDataResolver.attributeNames()));
    }

    private static LdapSession.GroupsResolver groupResolver(RealmConfig realmConfig) {
        if (realmConfig.hasSetting(SearchGroupsResolverSettings.BASE_DN)) {
            return new SearchGroupsResolver(realmConfig);
        }
        return new UserAttributeGroupsResolver(realmConfig);
    }

    static String getSearchFilter(RealmConfig config) {
        boolean hasAttribute = config.hasSetting(LdapUserSearchSessionFactorySettings.SEARCH_ATTRIBUTE);
        boolean hasFilter = config.hasSetting(LdapUserSearchSessionFactorySettings.SEARCH_FILTER);
        if (hasAttribute && hasFilter) {
            throw new IllegalArgumentException("search attribute setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapUserSearchSessionFactorySettings.SEARCH_ATTRIBUTE) + "] and filter setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)LdapUserSearchSessionFactorySettings.SEARCH_FILTER) + "] cannot be combined!");
        }
        if (hasFilter) {
            return (String)config.getSetting(LdapUserSearchSessionFactorySettings.SEARCH_FILTER);
        }
        if (hasAttribute) {
            return "(" + (String)config.getSetting(LdapUserSearchSessionFactorySettings.SEARCH_ATTRIBUTE) + "={0})";
        }
        return "(uid={0})";
    }
}

