/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file.tool;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.LoggingAwareMultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.authc.file.FileUserPasswdStore;
import org.elasticsearch.xpack.security.authc.file.FileUserRolesStore;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.support.FileAttributesChecker;

public class UsersTool
extends LoggingAwareMultiCommand {
    public static void main(String[] args) throws Exception {
        UsersTool.exit((int)new UsersTool().main(args, Terminal.DEFAULT));
    }

    UsersTool() {
        super("Manages elasticsearch file users");
        this.subcommands.put("useradd", this.newAddUserCommand());
        this.subcommands.put("userdel", this.newDeleteUserCommand());
        this.subcommands.put("passwd", this.newPasswordCommand());
        this.subcommands.put("roles", this.newRolesCommand());
        this.subcommands.put("list", this.newListCommand());
    }

    protected AddUserCommand newAddUserCommand() {
        return new AddUserCommand();
    }

    protected DeleteUserCommand newDeleteUserCommand() {
        return new DeleteUserCommand();
    }

    protected PasswordCommand newPasswordCommand() {
        return new PasswordCommand();
    }

    protected RolesCommand newRolesCommand() {
        return new RolesCommand();
    }

    protected ListCommand newListCommand() {
        return new ListCommand();
    }

    static void listUsersAndRoles(Terminal terminal, Environment env, String username) throws Exception {
        Path userRolesFilePath = FileUserRolesStore.resolveFile(env);
        Map<String, String[]> userRoles = FileUserRolesStore.parseFile(userRolesFilePath, null);
        if (userRoles == null) {
            throw new UserException(78, "Configuration file [" + userRolesFilePath + "] is missing");
        }
        Path userFilePath = FileUserPasswdStore.resolveFile(env);
        Map<String, char[]> users = FileUserPasswdStore.parseFile(userFilePath, null, env.settings());
        if (users == null) {
            throw new UserException(78, "Configuration file [" + userFilePath + "] is missing");
        }
        Path rolesFilePath = FileRolesStore.resolveFile(env);
        Set knownRoles = Sets.union(FileRolesStore.parseFileForRoleNames(rolesFilePath, null), (Set)ReservedRolesStore.names());
        if (knownRoles == null) {
            throw new UserException(78, "Configuration file [" + rolesFilePath + "] is missing");
        }
        if (username != null) {
            if (!users.containsKey(username)) {
                throw new UserException(67, "User [" + username + "] doesn't exist");
            }
            if (userRoles.containsKey(username)) {
                Object[] roles = userRoles.get(username);
                Set unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), (Set)knownRoles);
                String[] markedRoles = UsersTool.markUnknownRoles((String[])roles, unknownRoles);
                terminal.println(String.format(Locale.ROOT, "%-15s: %s", username, Arrays.stream(markedRoles).map(s -> s == null ? "-" : s).collect(Collectors.joining(","))));
                if (!unknownRoles.isEmpty()) {
                    Path path = FileRolesStore.resolveFile(env).toAbsolutePath();
                    terminal.println("");
                    terminal.println(" [*]   Role is not in the [" + path.toAbsolutePath() + "] file. If the role has been created using the API, please disregard this message.");
                }
            } else {
                terminal.println(String.format(Locale.ROOT, "%-15s: -", username));
            }
        } else {
            boolean unknownRolesFound = false;
            boolean usersExist = false;
            for (Map.Entry<String, String[]> entry : userRoles.entrySet()) {
                Object[] roles = entry.getValue();
                Set unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), (Set)knownRoles);
                CharSequence[] markedRoles = UsersTool.markUnknownRoles((String[])roles, unknownRoles);
                terminal.println(String.format(Locale.ROOT, "%-15s: %s", entry.getKey(), String.join((CharSequence)",", markedRoles)));
                unknownRolesFound = unknownRolesFound || !unknownRoles.isEmpty();
                usersExist = true;
            }
            HashSet usersWithoutRoles = Sets.newHashSet(users.keySet());
            usersWithoutRoles.removeAll(userRoles.keySet());
            for (String user : usersWithoutRoles) {
                terminal.println(String.format(Locale.ROOT, "%-15s: -", user));
                usersExist = true;
            }
            if (!usersExist) {
                terminal.println("No users found");
                return;
            }
            if (unknownRolesFound) {
                Path path = FileRolesStore.resolveFile(env).toAbsolutePath();
                terminal.println("");
                terminal.println(" [*]   Role is not in the [" + path.toAbsolutePath() + "] file. If the role has been created using the API, please disregard this message.");
            }
        }
    }

    private static String[] markUnknownRoles(String[] roles, Set<String> unknownRoles) {
        if (unknownRoles.isEmpty()) {
            return roles;
        }
        String[] marked = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            marked[i] = unknownRoles.contains(roles[i]) ? roles[i] + "*" : roles[i];
        }
        return marked;
    }

    static String parseUsername(List<String> args, Settings settings) throws UserException {
        boolean allowReserved;
        if (args.isEmpty()) {
            throw new UserException(64, "Missing username argument");
        }
        if (args.size() > 1) {
            throw new UserException(64, "Expected a single username argument, found extra: " + args.toString());
        }
        String username = args.get(0);
        Validation.Error validationError = Validation.Users.validateUsername((String)username, (boolean)(allowReserved = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings) == false), (Settings)settings);
        if (validationError != null) {
            throw new UserException(65, "Invalid username [" + username + "]... " + validationError);
        }
        return username;
    }

    private static char[] getPasswordHash(Terminal terminal, Environment env, String cliPasswordValue) throws UserException {
        char[] passwordHash;
        Hasher hasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(env.settings())));
        try (SecureString password = UsersTool.parsePassword(terminal, cliPasswordValue);){
            passwordHash = hasher.hash(password);
        }
        return passwordHash;
    }

    static SecureString parsePassword(Terminal terminal, String passwordStr) throws UserException {
        SecureString password;
        if (passwordStr != null) {
            password = new SecureString(passwordStr.toCharArray());
            Validation.Error validationError = Validation.Users.validatePassword((SecureString)password);
            if (validationError != null) {
                throw new UserException(65, "Invalid password..." + validationError);
            }
        } else {
            password = new SecureString(terminal.readSecret("Enter new password: "));
            Validation.Error validationError = Validation.Users.validatePassword((SecureString)password);
            if (validationError != null) {
                throw new UserException(65, "Invalid password..." + validationError);
            }
            char[] retyped = terminal.readSecret("Retype new password: ");
            if (!Arrays.equals(password.getChars(), retyped)) {
                throw new UserException(65, "Password mismatch");
            }
        }
        return password;
    }

    private static void verifyRoles(Terminal terminal, Environment env, String[] roles) {
        Path rolesFile = FileRolesStore.resolveFile(env);
        assert (Files.exists(rolesFile, new LinkOption[0]));
        Set knownRoles = Sets.union(FileRolesStore.parseFileForRoleNames(rolesFile, null), (Set)ReservedRolesStore.names());
        Set unknownRoles = Sets.difference((Set)Sets.newHashSet((Object[])roles), (Set)knownRoles);
        if (!unknownRoles.isEmpty()) {
            terminal.errorPrintln(String.format(Locale.ROOT, "Warning: The following roles [%s] are not in the [%s] file. Make sure the names are correct. If the names are correct and the roles were created using the API please disregard this message. Nonetheless the user will still be associated with all specified roles", Strings.collectionToCommaDelimitedString((Iterable)unknownRoles), rolesFile.toAbsolutePath()));
            terminal.errorPrintln("Known roles: " + knownRoles.toString());
        }
    }

    static String[] parseRoles(Terminal terminal, Environment env, String rolesStr) throws UserException {
        String[] roles;
        if (rolesStr.isEmpty()) {
            return Strings.EMPTY_ARRAY;
        }
        for (String role : roles = rolesStr.split(",")) {
            Validation.Error validationError = Validation.Roles.validateRoleName((String)role, (boolean)true);
            if (validationError == null) continue;
            throw new UserException(65, "Invalid role [" + role + "]... " + validationError);
        }
        UsersTool.verifyRoles(terminal, env, roles);
        return roles;
    }

    static class ListCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> arguments;

        ListCommand() {
            super("List existing file based users and their corresponding roles");
            this.arguments = this.parser.nonOptions("username");
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("");
            terminal.println("");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            String username = null;
            if (options.has(this.arguments)) {
                username = (String)this.arguments.value(options);
            }
            UsersTool.listUsersAndRoles(terminal, env, username);
        }
    }

    static class RolesCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> addOption;
        private final OptionSpec<String> removeOption;
        private final OptionSpec<String> arguments;

        RolesCommand() {
            super("Edit roles of an existing user");
            this.addOption = this.parser.acceptsAll(Arrays.asList("a", "add"), "Adds supplied roles to the specified user").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
            this.removeOption = this.parser.acceptsAll(Arrays.asList("r", "remove"), "Remove supplied roles from the specified user").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
            this.arguments = this.parser.nonOptions("username");
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("The roles command allows editing roles for file based users.");
            terminal.println("You can also list a user's roles by omitting the -a and -r");
            terminal.println("parameters.");
            terminal.println("");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            boolean readOnlyUserListing;
            String username = UsersTool.parseUsername(this.arguments.values(options), env.settings());
            String[] addRoles = UsersTool.parseRoles(terminal, env, (String)this.addOption.value(options));
            String[] removeRoles = UsersTool.parseRoles(terminal, env, (String)this.removeOption.value(options));
            boolean bl = readOnlyUserListing = removeRoles.length == 0 && addRoles.length == 0;
            if (readOnlyUserListing) {
                UsersTool.listUsersAndRoles(terminal, env, username);
                return;
            }
            Path usersFile = FileUserPasswdStore.resolveFile(env);
            Path rolesFile = FileUserRolesStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(usersFile, rolesFile);
            Map<String, char[]> usersMap = FileUserPasswdStore.parseFile(usersFile, null, env.settings());
            if (!usersMap.containsKey(username)) {
                throw new UserException(67, "User [" + username + "] doesn't exist");
            }
            Map<String, String[]> userRoles = FileUserRolesStore.parseFile(rolesFile, null);
            ArrayList<String> roles = new ArrayList<String>();
            if (userRoles.get(username) != null) {
                roles.addAll(Arrays.asList(userRoles.get(username)));
            }
            roles.addAll(Arrays.asList(addRoles));
            roles.removeAll(Arrays.asList(removeRoles));
            HashMap<String, String[]> userRolesToWrite = new HashMap<String, String[]>(userRoles.size());
            userRolesToWrite.putAll(userRoles);
            if (roles.isEmpty()) {
                userRolesToWrite.remove(username);
            } else {
                userRolesToWrite.put(username, new LinkedHashSet(roles).toArray(new String[0]));
            }
            FileUserRolesStore.writeFile(userRolesToWrite, rolesFile);
            attributesChecker.check(terminal);
        }
    }

    static class PasswordCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> passwordOption;
        private final OptionSpec<String> arguments;

        PasswordCommand() {
            super("Changes the password of an existing file based user");
            this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "The user password").withRequiredArg();
            this.arguments = this.parser.nonOptions("username");
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("The passwd command changes passwords for file based users. The tool");
            terminal.println("prompts twice for a replacement password. The second entry is compared");
            terminal.println("against the first and both are required to match in order for the");
            terminal.println("password to be changed.");
            terminal.println("");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            String username = UsersTool.parseUsername(this.arguments.values(options), env.settings());
            char[] passwordHash = UsersTool.getPasswordHash(terminal, env, (String)this.passwordOption.value(options));
            Path file = FileUserPasswdStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(file);
            Map<String, char[]> users = FileUserPasswdStore.parseFile(file, null, env.settings());
            if (users == null) {
                throw new UserException(78, "Configuration file [" + file + "] is missing");
            }
            if (!users.containsKey(username)) {
                throw new UserException(67, "User [" + username + "] doesn't exist");
            }
            users = new HashMap<String, char[]>(users);
            users.put(username, passwordHash);
            FileUserPasswdStore.writeFile(users, file);
            attributesChecker.check(terminal);
        }
    }

    static class DeleteUserCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> arguments;

        DeleteUserCommand() {
            super("Deletes a file based user");
            this.arguments = this.parser.nonOptions("username");
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("Removes an existing file based user from elasticsearch. The user will be");
            terminal.println("removed from the \"users\" file and its roles will be removed from the");
            terminal.println("\"users_roles\" file in the elasticsearch config directory.");
            terminal.println("");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            String[] roles;
            char[] passwd;
            String username = UsersTool.parseUsername(this.arguments.values(options), env.settings());
            Path passwordFile = FileUserPasswdStore.resolveFile(env);
            Path rolesFile = FileUserRolesStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(passwordFile, rolesFile);
            Map<String, char[]> users = FileUserPasswdStore.parseFile(passwordFile, null, env.settings());
            if (users == null) {
                throw new UserException(78, "Configuration file [" + passwordFile + "] is missing");
            }
            if (!users.containsKey(username)) {
                throw new UserException(67, "User [" + username + "] doesn't exist");
            }
            if (Files.exists(passwordFile, new LinkOption[0]) && (passwd = (users = new HashMap<String, char[]>(users)).remove(username)) != null) {
                FileUserPasswdStore.writeFile(users, passwordFile);
            }
            HashMap<String, String[]> userRoles = new HashMap<String, String[]>(FileUserRolesStore.parseFile(rolesFile, null));
            if (Files.exists(rolesFile, new LinkOption[0]) && (roles = (String[])userRoles.remove(username)) != null) {
                FileUserRolesStore.writeFile(userRoles, rolesFile);
            }
            attributesChecker.check(terminal);
        }
    }

    static class AddUserCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> passwordOption;
        private final OptionSpec<String> rolesOption;
        private final OptionSpec<String> arguments;

        AddUserCommand() {
            super("Adds a file user");
            this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "The user password").withRequiredArg();
            this.rolesOption = this.parser.acceptsAll(Arrays.asList("r", "roles"), "Comma-separated list of the roles of the user").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]);
            this.arguments = this.parser.nonOptions("username");
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("Adds a file based user to elasticsearch (via internal realm). The user will");
            terminal.println("be added to the \"users\" file and its roles will be added to the");
            terminal.println("\"users_roles\" file in the elasticsearch config directory.");
            terminal.println("");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            boolean allowReserved;
            String username = UsersTool.parseUsername(this.arguments.values(options), env.settings());
            Validation.Error validationError = Validation.Users.validateUsername((String)username, (boolean)(allowReserved = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(env.settings()) == false), (Settings)env.settings());
            if (validationError != null) {
                throw new UserException(65, "Invalid username [" + username + "]... " + validationError);
            }
            char[] passwordHash = UsersTool.getPasswordHash(terminal, env, (String)this.passwordOption.value(options));
            String[] roles = UsersTool.parseRoles(terminal, env, (String)this.rolesOption.value(options));
            Path passwordFile = FileUserPasswdStore.resolveFile(env);
            Path rolesFile = FileUserRolesStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(passwordFile, rolesFile);
            Map<String, char[]> users = FileUserPasswdStore.parseFile(passwordFile, null, env.settings());
            if (users == null) {
                throw new UserException(78, "Configuration file [" + passwordFile + "] is missing");
            }
            if (users.containsKey(username)) {
                throw new UserException(70, "User [" + username + "] already exists");
            }
            users = new HashMap<String, char[]>(users);
            users.put(username, passwordHash);
            FileUserPasswdStore.writeFile(users, passwordFile);
            if (roles.length > 0) {
                HashMap<String, String[]> userRoles = new HashMap<String, String[]>(FileUserRolesStore.parseFile(rolesFile, null));
                userRoles.put(username, roles);
                FileUserRolesStore.writeFile(userRoles, rolesFile);
            }
            attributesChecker.check(terminal);
        }
    }
}

