/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

final class ExpiredTokenRemover
extends AbstractRunnable {
    private static final Logger logger = LogManager.getLogger(ExpiredTokenRemover.class);
    public static final long MAXIMUM_TOKEN_LIFETIME_HOURS = 24L;
    private final Client client;
    private final SecurityIndexManager securityMainIndex;
    private final SecurityIndexManager securityTokensIndex;
    private final AtomicBoolean inProgress;
    private final TimeValue timeout;
    private boolean checkMainIndexForExpiredTokens;

    ExpiredTokenRemover(Settings settings, Client client, SecurityIndexManager securityMainIndex, SecurityIndexManager securityTokensIndex) {
        this.client = client;
        this.securityMainIndex = securityMainIndex;
        this.securityTokensIndex = securityTokensIndex;
        this.inProgress = new AtomicBoolean(false);
        this.timeout = (TimeValue)TokenService.DELETE_TIMEOUT.get(settings);
        this.checkMainIndexForExpiredTokens = true;
    }

    public void doRun() {
        ArrayList<String> indicesWithTokens = new ArrayList<String>();
        if (this.securityTokensIndex.isAvailable()) {
            indicesWithTokens.add(this.securityTokensIndex.aliasName());
        }
        if (this.securityMainIndex.isAvailable() && this.checkMainIndexForExpiredTokens) {
            indicesWithTokens.add(this.securityMainIndex.aliasName());
        }
        if (indicesWithTokens.isEmpty()) {
            return;
        }
        DeleteByQueryRequest expiredDbq = new DeleteByQueryRequest(indicesWithTokens.toArray(new String[0]));
        if (this.timeout != TimeValue.MINUS_ONE) {
            expiredDbq.setTimeout(this.timeout);
            expiredDbq.getSearchRequest().source().timeout(this.timeout);
        }
        Instant now = Instant.now();
        expiredDbq.setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"token"})).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"creation_time").lte((Object)now.minus(24L, ChronoUnit.HOURS).toEpochMilli())));
        logger.trace(() -> new ParameterizedMessage("Removing old tokens: [{}]", (Object)Strings.toString((ToXContent)expiredDbq)));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)expiredDbq, (ActionListener)ActionListener.wrap(bulkResponse -> {
            this.debugDbqResponse((BulkByScrollResponse)bulkResponse);
            if (this.checkMainIndexForExpiredTokens && this.securityTokensIndex.indexExists() && this.securityTokensIndex.getCreationTime().isBefore(now.minus(24L, ChronoUnit.HOURS)) && bulkResponse.getBulkFailures().isEmpty() && bulkResponse.getSearchFailures().isEmpty()) {
                this.checkMainIndexForExpiredTokens = false;
            }
            this.markComplete();
        }, this::onFailure));
    }

    void submit(ThreadPool threadPool) {
        if (this.inProgress.compareAndSet(false, true)) {
            threadPool.executor("generic").submit((Runnable)((Object)this));
        }
    }

    private void debugDbqResponse(BulkByScrollResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("delete by query of tokens finished with [{}] deletions, [{}] bulk failures, [{}] search failures", (Object)response.getDeleted(), (Object)response.getBulkFailures().size(), (Object)response.getSearchFailures().size());
            for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                logger.debug((Message)new ParameterizedMessage("deletion failed for index [{}], type [{}], id [{}]", new Object[]{failure.getIndex(), failure.getType(), failure.getId()}), (Throwable)failure.getCause());
            }
            for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                logger.debug((Message)new ParameterizedMessage("search failed for index [{}], shard [{}] on node [{}]", new Object[]{failure.getIndex(), failure.getShardId(), failure.getNodeId()}), failure.getReason());
            }
        }
    }

    boolean isExpirationInProgress() {
        return this.inProgress.get();
    }

    public void onFailure(Exception e) {
        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
            logger.debug("failed to delete expired tokens", (Throwable)e);
        } else {
            logger.error("failed to delete expired tokens", (Throwable)e);
        }
        this.markComplete();
    }

    private void markComplete() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new IllegalStateException("in progress was set to false but should have been true!");
        }
    }
}

