/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.logfile;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.MarkerFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class LoggingAuditTrail
implements AuditTrail,
ClusterStateListener {
    public static final String REST_ORIGIN_FIELD_VALUE = "rest";
    public static final String LOCAL_ORIGIN_FIELD_VALUE = "local_node";
    public static final String TRANSPORT_ORIGIN_FIELD_VALUE = "transport";
    public static final String IP_FILTER_ORIGIN_FIELD_VALUE = "ip_filter";
    public static final String LOG_TYPE = "type";
    public static final String TIMESTAMP = "timestamp";
    public static final String ORIGIN_TYPE_FIELD_NAME = "origin.type";
    public static final String ORIGIN_ADDRESS_FIELD_NAME = "origin.address";
    public static final String NODE_NAME_FIELD_NAME = "node.name";
    public static final String NODE_ID_FIELD_NAME = "node.id";
    public static final String HOST_ADDRESS_FIELD_NAME = "host.ip";
    public static final String HOST_NAME_FIELD_NAME = "host.name";
    public static final String EVENT_TYPE_FIELD_NAME = "event.type";
    public static final String EVENT_ACTION_FIELD_NAME = "event.action";
    public static final String PRINCIPAL_FIELD_NAME = "user.name";
    public static final String PRINCIPAL_RUN_BY_FIELD_NAME = "user.run_by.name";
    public static final String PRINCIPAL_RUN_AS_FIELD_NAME = "user.run_as.name";
    public static final String PRINCIPAL_REALM_FIELD_NAME = "user.realm";
    public static final String PRINCIPAL_RUN_BY_REALM_FIELD_NAME = "user.run_by.realm";
    public static final String PRINCIPAL_RUN_AS_REALM_FIELD_NAME = "user.run_as.realm";
    public static final String PRINCIPAL_ROLES_FIELD_NAME = "user.roles";
    public static final String REALM_FIELD_NAME = "realm";
    public static final String URL_PATH_FIELD_NAME = "url.path";
    public static final String URL_QUERY_FIELD_NAME = "url.query";
    public static final String REQUEST_METHOD_FIELD_NAME = "request.method";
    public static final String REQUEST_BODY_FIELD_NAME = "request.body";
    public static final String REQUEST_ID_FIELD_NAME = "request.id";
    public static final String ACTION_FIELD_NAME = "action";
    public static final String INDICES_FIELD_NAME = "indices";
    public static final String REQUEST_NAME_FIELD_NAME = "request.name";
    public static final String TRANSPORT_PROFILE_FIELD_NAME = "transport.profile";
    public static final String RULE_FIELD_NAME = "rule";
    public static final String OPAQUE_ID_FIELD_NAME = "opaque_id";
    public static final String X_FORWARDED_FOR_FIELD_NAME = "x_forwarded_for";
    public static final String NAME = "logfile";
    public static final Setting<Boolean> EMIT_HOST_ADDRESS_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_host_address"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_HOST_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_host_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_NODE_NAME_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_name"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> EMIT_NODE_ID_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.emit_node_id"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString());
    public static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.logfile.events.include"), DEFAULT_EVENT_INCLUDES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.logfile.events.exclude"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting((String)SecurityField.setting((String)"audit.logfile.events.emit_request_body"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final String FILTER_POLICY_PREFIX = SecurityField.setting((String)"audit.logfile.events.ignore_filters.");
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_PRINCIPALS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"users", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_REALMS = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"realms", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_ROLES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"roles", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Setting.AffixSetting<List<String>> FILTER_POLICY_IGNORE_INDICES = Setting.affixKeySetting((String)FILTER_POLICY_PREFIX, (String)"indices", key -> Setting.listSetting((String)key, Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final Marker AUDIT_MARKER = MarkerManager.getMarker((String)"org.elasticsearch.xpack.security.audit");
    private final Logger logger;
    private final ThreadContext threadContext;
    final EventFilterPolicyRegistry eventFilterPolicyRegistry;
    volatile EnumSet<AuditLevel> events;
    boolean includeRequestBody;
    EntryCommonFields entryCommonFields;

    @Override
    public String name() {
        return NAME;
    }

    public LoggingAuditTrail(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        this(settings, clusterService, LogManager.getLogger(LoggingAuditTrail.class), threadPool.getThreadContext());
    }

    LoggingAuditTrail(Settings settings, ClusterService clusterService, Logger logger, ThreadContext threadContext) {
        this.logger = logger;
        this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(settings), (List)EXCLUDE_EVENT_SETTINGS.get(settings));
        this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(settings);
        this.threadContext = threadContext;
        this.entryCommonFields = new EntryCommonFields(settings, null);
        this.eventFilterPolicyRegistry = new EventFilterPolicyRegistry(settings);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(newSettings -> {
            this.entryCommonFields = this.entryCommonFields.withNewSettings((Settings)newSettings);
            this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(newSettings);
            this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(newSettings), (List)EXCLUDE_EVENT_SETTINGS.get(newSettings));
        }, Arrays.asList(EMIT_HOST_ADDRESS_SETTING, EMIT_HOST_NAME_SETTING, EMIT_NODE_NAME_SETTING, EMIT_NODE_ID_SETTING, INCLUDE_EVENT_SETTINGS, EXCLUDE_EVENT_SETTINGS, INCLUDE_REQUEST_BODY));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_PRINCIPALS, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changePrincipalsFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_REALMS, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeRealmsFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_ROLES, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeRolesFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(FILTER_POLICY_IGNORE_INDICES, (policyName, filtersList) -> {
            Optional policy = this.eventFilterPolicyRegistry.get(policyName);
            EventFilterPolicy newPolicy = policy.orElse(new EventFilterPolicy((String)policyName, settings)).changeIndicesFilter(filtersList);
            this.eventFilterPolicyRegistry.set(policyName, newPolicy);
        }, (policyName, filtersList) -> EventFilterPolicy.parsePredicate(filtersList));
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        MarkerFilter auditMarkerFilter = MarkerFilter.createFilter((String)AUDIT_MARKER.getName(), (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        ctx.addFilter((Filter)auditMarkerFilter);
        ctx.updateLoggers();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ignored -> LogManager.getLogger(Security.class).warn("Changing log level for [" + LoggingAuditTrail.class.getName() + "] has no effect"), Collections.singletonList(Loggers.LOG_LEVEL_SETTING.getConcreteSettingForNamespace(LoggingAuditTrail.class.getName())));
    }

    @Override
    public void authenticationSuccess(String requestId, String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), Optional.empty()))) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_success").with(REALM_FIELD_NAME, realm).withRestUriAndMethod(request).withRequestId(requestId).withPrincipal(user).withRestOrigin(request).withRequestBody(request).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void authenticationSuccess(String requestId, String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_success").with(REALM_FIELD_NAME, realm).with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withPrincipal(user).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "anonymous_access_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String requestId, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "anonymous_access_denied").withRestUriAndMethod(request).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(ACTION_FIELD_NAME, action).with(PRINCIPAL_FIELD_NAME, token.principal()).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").withRestUriAndMethod(request).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void authenticationFailed(String requestId, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.empty(), Optional.empty()))) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "authentication_failed").with(PRINCIPAL_FIELD_NAME, token.principal()).withRestUriAndMethod(request).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "realm_authentication_failed").with(REALM_FIELD_NAME, realm).with(PRINCIPAL_FIELD_NAME, token.principal()).with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void authenticationFailed(String requestId, String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(token), Optional.of(realm), Optional.empty()))) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "realm_authentication_failed").with(REALM_FIELD_NAME, realm).with(PRINCIPAL_FIELD_NAME, token.principal()).withRestUriAndMethod(request).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void accessGranted(String requestId, Authentication authentication, String action, TransportMessage msg, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        boolean isSystem;
        User user = authentication.getUser();
        boolean bl = isSystem = SystemUser.is((User)user) || XPackUser.is((User)user);
        if (isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED) || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(msg);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "access_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, msg.getClass().getSimpleName()).withRequestId(requestId).withSubject(authentication).withRestOrTransportOrigin(msg, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).with(authorizationInfo.asMap()).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void explicitIndexAccessEvent(String requestId, AuditLevel eventType, Authentication authentication, String action, String index, String requestName, TransportAddress remoteAddress, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        boolean isSystem;
        String[] stringArray;
        assert (eventType == AuditLevel.ACCESS_DENIED || eventType == AuditLevel.ACCESS_GRANTED || eventType == AuditLevel.SYSTEM_ACCESS_GRANTED);
        if (index == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = index;
        }
        String[] indices = stringArray;
        User user = authentication.getUser();
        boolean bl = isSystem = SystemUser.is((User)user) || XPackUser.is((User)user);
        if (isSystem && eventType == AuditLevel.ACCESS_GRANTED) {
            eventType = AuditLevel.SYSTEM_ACCESS_GRANTED;
        }
        if (this.events.contains((Object)eventType) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), Optional.ofNullable(indices)))) {
            LogEntryBuilder logEntryBuilder = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, eventType == AuditLevel.ACCESS_DENIED ? "access_denied" : "access_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, requestName).withRequestId(requestId).withSubject(authentication).with(INDICES_FIELD_NAME, indices).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).with(authorizationInfo.asMap());
            InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(this.threadContext);
            if (restAddress != null) {
                logEntryBuilder.with(ORIGIN_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)restAddress));
            } else if (remoteAddress != null) {
                logEntryBuilder.with(ORIGIN_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)remoteAddress.address()));
            }
            this.logger.info(AUDIT_MARKER, (Message)logEntryBuilder.build());
        }
    }

    @Override
    public void accessDenied(String requestId, Authentication authentication, String action, TransportMessage message, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "access_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withSubject(authentication).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").withRestUriAndMethod(request).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void tamperedRequest(String requestId, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void tamperedRequest(String requestId, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(user), Optional.empty(), Optional.empty(), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "tampered_request").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRestOrTransportOrigin(message, this.threadContext).withPrincipal(user).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, IP_FILTER_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "connection_granted").with(ORIGIN_TYPE_FIELD_NAME, ".http".equals(profile) ? REST_ORIGIN_FIELD_VALUE : TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetAddress)inetAddress)).with(TRANSPORT_PROFILE_FIELD_NAME, profile).with(RULE_FIELD_NAME, rule.toString()).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(AuditEventMetaInfo.EMPTY)) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, IP_FILTER_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "connection_denied").with(ORIGIN_TYPE_FIELD_NAME, ".http".equals(profile) ? REST_ORIGIN_FIELD_VALUE : TRANSPORT_ORIGIN_FIELD_VALUE).with(ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetAddress)inetAddress)).with(TRANSPORT_PROFILE_FIELD_NAME, profile).with(RULE_FIELD_NAME, rule.toString()).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    @Override
    public void runAsGranted(String requestId, Authentication authentication, String action, TransportMessage message, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_granted").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRunAsSubject(authentication).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, String action, TransportMessage message, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            Optional<String[]> indices = LoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), indices))) {
                StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, TRANSPORT_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_denied").with(ACTION_FIELD_NAME, action).with(REQUEST_NAME_FIELD_NAME, message.getClass().getSimpleName()).withRequestId(requestId).withRunAsSubject(authentication).withRestOrTransportOrigin(message, this.threadContext).with(INDICES_FIELD_NAME, (String[])indices.orElse(null)).with(authorizationInfo.asMap()).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
                this.logger.info(AUDIT_MARKER, (Message)logEntry);
            }
        }
    }

    @Override
    public void runAsDenied(String requestId, Authentication authentication, RestRequest request, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(LoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(authorizationInfo), Optional.empty()))) {
            StringMapMessage logEntry = new LogEntryBuilder().with(EVENT_TYPE_FIELD_NAME, REST_ORIGIN_FIELD_VALUE).with(EVENT_ACTION_FIELD_NAME, "run_as_denied").with(authorizationInfo.asMap()).withRestUriAndMethod(request).withRunAsSubject(authentication).withRestOrigin(request).withRequestBody(request).withRequestId(requestId).withOpaqueId(this.threadContext).withXForwardedFor(this.threadContext).build();
            this.logger.info(AUDIT_MARKER, (Message)logEntry);
        }
    }

    private static Optional<String[]> indices(TransportMessage message) {
        String[] indices;
        if (message instanceof IndicesRequest && (indices = ((IndicesRequest)message).indices()) != null) {
            return Optional.of(((IndicesRequest)message).indices());
        }
        return Optional.empty();
    }

    private static String effectiveRealmName(Authentication authentication) {
        return authentication.getLookedUpBy() != null ? authentication.getLookedUpBy().getName() : authentication.getAuthenticatedBy().getName();
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(EMIT_HOST_ADDRESS_SETTING);
        settings.add(EMIT_HOST_NAME_SETTING);
        settings.add(EMIT_NODE_NAME_SETTING);
        settings.add(EMIT_NODE_ID_SETTING);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_PRINCIPALS);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_INDICES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_ROLES);
        settings.add((Setting<?>)FILTER_POLICY_IGNORE_REALMS);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.updateLocalNodeInfo(event.state().getNodes().getLocalNode());
    }

    void updateLocalNodeInfo(DiscoveryNode newLocalNode) {
        EntryCommonFields localNodeInfo = this.entryCommonFields;
        if (localNodeInfo.localNode == null || !localNodeInfo.localNode.equals((Object)newLocalNode)) {
            this.entryCommonFields = this.entryCommonFields.withNewLocalNode(newLocalNode);
        }
    }

    static class EntryCommonFields {
        private final Settings settings;
        private final DiscoveryNode localNode;
        final Map<String, String> commonFields;

        EntryCommonFields(Settings settings, @Nullable DiscoveryNode newLocalNode) {
            String nodeName;
            this.settings = settings;
            this.localNode = newLocalNode;
            HashMap<String, String> commonFields = new HashMap<String, String>();
            if (((Boolean)EMIT_NODE_NAME_SETTING.get(settings)).booleanValue() && Strings.hasLength((String)(nodeName = (String)Node.NODE_NAME_SETTING.get(settings)))) {
                commonFields.put(LoggingAuditTrail.NODE_NAME_FIELD_NAME, nodeName);
            }
            if (newLocalNode != null && newLocalNode.getAddress() != null) {
                if (((Boolean)EMIT_HOST_ADDRESS_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.HOST_ADDRESS_FIELD_NAME, newLocalNode.getAddress().getAddress());
                }
                if (((Boolean)EMIT_HOST_NAME_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.HOST_NAME_FIELD_NAME, newLocalNode.getAddress().address().getHostString());
                }
                if (((Boolean)EMIT_NODE_ID_SETTING.get(settings)).booleanValue()) {
                    commonFields.put(LoggingAuditTrail.NODE_ID_FIELD_NAME, newLocalNode.getId());
                }
                commonFields.put(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, newLocalNode.getAddress().toString());
            }
            commonFields.put(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE);
            this.commonFields = Collections.unmodifiableMap(commonFields);
        }

        EntryCommonFields withNewSettings(Settings newSettings) {
            Settings mergedSettings = Settings.builder().put(this.settings).put(newSettings, false).build();
            return new EntryCommonFields(mergedSettings, this.localNode);
        }

        EntryCommonFields withNewLocalNode(DiscoveryNode newLocalNode) {
            return new EntryCommonFields(this.settings, newLocalNode);
        }
    }

    static final class AuditEventMetaInfo {
        final String principal;
        final String realm;
        final Supplier<Stream<String>> roles;
        final Supplier<Stream<String>> indices;
        static final AuditEventMetaInfo EMPTY = new AuditEventMetaInfo(Optional.empty(), Optional.empty(), Optional.empty());

        AuditEventMetaInfo(Optional<User> user, Optional<String> realm, Optional<AuthorizationEngine.AuthorizationInfo> authorizationInfo, Optional<String[]> indices) {
            this.principal = user.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.roles = () -> authorizationInfo.filter(info -> {
                Object value = info.asMap().get(LoggingAuditTrail.PRINCIPAL_ROLES_FIELD_NAME);
                return value instanceof String[] && ((String[])value).length != 0 && Arrays.stream((String[])value).anyMatch(Objects::nonNull);
            }).map(info -> Arrays.stream((String[])info.asMap().get(LoggingAuditTrail.PRINCIPAL_ROLES_FIELD_NAME))).orElse(Stream.of(""));
            this.indices = () -> indices.filter(i -> ((String[])i).length > 0).filter(a -> Arrays.stream(a).anyMatch(Objects::nonNull)).map(Arrays::stream).orElse(Stream.of(""));
        }

        AuditEventMetaInfo(Optional<AuthenticationToken> authenticationToken, Optional<String> realm, Optional<String[]> indices) {
            this.principal = authenticationToken.map(u -> u.principal()).orElse("");
            this.realm = realm.orElse("");
            this.roles = () -> Stream.of("");
            this.indices = () -> indices.filter(r -> ((String[])r).length != 0).map(i -> Arrays.stream(i)).orElse(Stream.of(""));
        }
    }

    static final class EventFilterPolicyRegistry {
        private volatile Map<String, EventFilterPolicy> policyMap;
        private volatile Predicate<AuditEventMetaInfo> predicate;

        private EventFilterPolicyRegistry(Settings settings) {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            for (String policyName : settings.getGroups(FILTER_POLICY_PREFIX, true).keySet()) {
                mapBuilder.put((Object)policyName, (Object)new EventFilterPolicy(policyName, settings));
            }
            this.policyMap = mapBuilder.immutableMap();
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        private Optional<EventFilterPolicy> get(String policyName) {
            return Optional.ofNullable(this.policyMap.get(policyName));
        }

        private synchronized void set(String policyName, EventFilterPolicy eventFilterPolicy) {
            this.policyMap = MapBuilder.newMapBuilder(this.policyMap).put((Object)policyName, (Object)eventFilterPolicy).immutableMap();
            this.predicate = EventFilterPolicyRegistry.buildIgnorePredicate(this.policyMap);
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return this.predicate;
        }

        private static Predicate<AuditEventMetaInfo> buildIgnorePredicate(Map<String, EventFilterPolicy> policyMap) {
            return policyMap.values().stream().map(EventFilterPolicy::ignorePredicate).reduce(x -> false, (x, y) -> x.or(y));
        }

        public String toString() {
            TreeMap<String, EventFilterPolicy> treeMap = new TreeMap<String, EventFilterPolicy>(this.policyMap);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : treeMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append(((EventFilterPolicy)entry.getValue()).toString());
            }
            return sb.toString();
        }
    }

    private static final class EventFilterPolicy {
        private final String name;
        private final Predicate<String> ignorePrincipalsPredicate;
        private final Predicate<String> ignoreRealmsPredicate;
        private final Predicate<String> ignoreRolesPredicate;
        private final Predicate<String> ignoreIndicesPredicate;

        EventFilterPolicy(String name, Settings settings) {
            this(name, EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_PRINCIPALS.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_REALMS.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_ROLES.getConcreteSettingForNamespace(name).get(settings)), EventFilterPolicy.parsePredicate((List)FILTER_POLICY_IGNORE_INDICES.getConcreteSettingForNamespace(name).get(settings)));
        }

        EventFilterPolicy(String name, Predicate<String> ignorePrincipalsPredicate, Predicate<String> ignoreRealmsPredicate, Predicate<String> ignoreRolesPredicate, Predicate<String> ignoreIndicesPredicate) {
            this.name = name;
            this.ignorePrincipalsPredicate = ignorePrincipalsPredicate;
            this.ignoreRealmsPredicate = ignoreRealmsPredicate;
            this.ignoreRolesPredicate = ignoreRolesPredicate;
            this.ignoreIndicesPredicate = ignoreIndicesPredicate;
        }

        private EventFilterPolicy changePrincipalsFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, EventFilterPolicy.parsePredicate(filtersList), this.ignoreRealmsPredicate, this.ignoreRolesPredicate, this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeRealmsFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, EventFilterPolicy.parsePredicate(filtersList), this.ignoreRolesPredicate, this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeRolesFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, this.ignoreRealmsPredicate, EventFilterPolicy.parsePredicate(filtersList), this.ignoreIndicesPredicate);
        }

        private EventFilterPolicy changeIndicesFilter(List<String> filtersList) {
            return new EventFilterPolicy(this.name, this.ignorePrincipalsPredicate, this.ignoreRealmsPredicate, this.ignoreRolesPredicate, EventFilterPolicy.parsePredicate(filtersList));
        }

        static Predicate<String> parsePredicate(List<String> l) {
            return Automatons.predicate(EventFilterPolicy.emptyStringBuildsEmptyAutomaton(l));
        }

        private static List<String> emptyStringBuildsEmptyAutomaton(List<String> l) {
            if (l.isEmpty()) {
                return Collections.singletonList("//");
            }
            return l.stream().map(f -> f.isEmpty() ? "//" : f).collect(Collectors.toList());
        }

        Predicate<AuditEventMetaInfo> ignorePredicate() {
            return eventInfo -> eventInfo.principal != null && this.ignorePrincipalsPredicate.test(eventInfo.principal) && eventInfo.realm != null && this.ignoreRealmsPredicate.test(eventInfo.realm) && eventInfo.roles.get().allMatch(role -> role != null && this.ignoreRolesPredicate.test((String)role)) && eventInfo.indices.get().allMatch(index -> index != null && this.ignoreIndicesPredicate.test((String)index));
        }

        public String toString() {
            return "[users]:" + this.ignorePrincipalsPredicate.toString() + "&[realms]:" + this.ignoreRealmsPredicate.toString() + "&[roles]:" + this.ignoreRolesPredicate.toString() + "&[indices]:" + this.ignoreIndicesPredicate.toString();
        }
    }

    private class LogEntryBuilder {
        private final StringMapMessage logEntry;

        LogEntryBuilder() {
            this.logEntry = new StringMapMessage(LoggingAuditTrail.this.entryCommonFields.commonFields);
        }

        LogEntryBuilder withRestUriAndMethod(RestRequest request) {
            int queryStringIndex = request.uri().indexOf(63);
            int queryStringLength = request.uri().indexOf(35);
            if (queryStringLength < 0) {
                queryStringLength = request.uri().length();
            }
            if (queryStringIndex < 0) {
                this.logEntry.with(LoggingAuditTrail.URL_PATH_FIELD_NAME, request.uri().substring(0, queryStringLength));
            } else {
                this.logEntry.with(LoggingAuditTrail.URL_PATH_FIELD_NAME, request.uri().substring(0, queryStringIndex));
            }
            if (queryStringIndex > -1) {
                this.logEntry.with(LoggingAuditTrail.URL_QUERY_FIELD_NAME, request.uri().substring(queryStringIndex + 1, queryStringLength));
            }
            this.logEntry.with(LoggingAuditTrail.REQUEST_METHOD_FIELD_NAME, request.method().toString());
            return this;
        }

        LogEntryBuilder withRunAsSubject(Authentication authentication) {
            ((StringMapMessage)((StringMapMessage)this.logEntry.with(LoggingAuditTrail.PRINCIPAL_FIELD_NAME, authentication.getUser().authenticatedUser().principal())).with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, authentication.getAuthenticatedBy().getName())).with(LoggingAuditTrail.PRINCIPAL_RUN_AS_FIELD_NAME, authentication.getUser().principal());
            if (authentication.getLookedUpBy() != null) {
                this.logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_AS_REALM_FIELD_NAME, authentication.getLookedUpBy().getName());
            }
            return this;
        }

        LogEntryBuilder withRestOrigin(RestRequest request) {
            assert (LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE.equals(this.logEntry.get(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME)));
            InetSocketAddress socketAddress = request.getHttpChannel().getRemoteAddress();
            if (socketAddress != null) {
                ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.REST_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)socketAddress));
            }
            return this;
        }

        LogEntryBuilder withRestOrTransportOrigin(TransportMessage message, ThreadContext threadContext) {
            assert (LoggingAuditTrail.LOCAL_ORIGIN_FIELD_VALUE.equals(this.logEntry.get(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME)));
            InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
            if (restAddress != null) {
                ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.REST_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)restAddress));
            } else {
                TransportAddress address = message.remoteAddress();
                if (address != null) {
                    ((StringMapMessage)this.logEntry.with(LoggingAuditTrail.ORIGIN_TYPE_FIELD_NAME, LoggingAuditTrail.TRANSPORT_ORIGIN_FIELD_VALUE)).with(LoggingAuditTrail.ORIGIN_ADDRESS_FIELD_NAME, NetworkAddress.format((InetSocketAddress)address.address()));
                }
            }
            return this;
        }

        LogEntryBuilder withRequestBody(RestRequest request) {
            String requestContent;
            if (LoggingAuditTrail.this.includeRequestBody && Strings.hasLength((String)(requestContent = AuditUtil.restRequestContent(request)))) {
                this.logEntry.with(LoggingAuditTrail.REQUEST_BODY_FIELD_NAME, requestContent);
            }
            return this;
        }

        LogEntryBuilder withRequestId(String requestId) {
            if (requestId != null) {
                this.logEntry.with(LoggingAuditTrail.REQUEST_ID_FIELD_NAME, requestId);
            }
            return this;
        }

        LogEntryBuilder withOpaqueId(ThreadContext threadContext) {
            String opaqueId = threadContext.getHeader("X-Opaque-Id");
            if (opaqueId != null) {
                this.logEntry.with(LoggingAuditTrail.OPAQUE_ID_FIELD_NAME, opaqueId);
            }
            return this;
        }

        LogEntryBuilder withXForwardedFor(ThreadContext threadContext) {
            String xForwardedFor = threadContext.getHeader("X-Forwarded-For");
            if (xForwardedFor != null) {
                this.logEntry.with(LoggingAuditTrail.X_FORWARDED_FOR_FIELD_NAME, xForwardedFor);
            }
            return this;
        }

        LogEntryBuilder withPrincipal(User user) {
            this.logEntry.with(LoggingAuditTrail.PRINCIPAL_FIELD_NAME, user.principal());
            if (user.isRunAs()) {
                this.logEntry.with(LoggingAuditTrail.PRINCIPAL_RUN_BY_FIELD_NAME, user.authenticatedUser().principal());
            }
            return this;
        }

        LogEntryBuilder withSubject(Authentication authentication) {
            this.logEntry.with(LoggingAuditTrail.PRINCIPAL_FIELD_NAME, authentication.getUser().principal());
            if (authentication.getUser().isRunAs()) {
                ((StringMapMessage)((StringMapMessage)this.logEntry.with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, authentication.getLookedUpBy().getName())).with(LoggingAuditTrail.PRINCIPAL_RUN_BY_FIELD_NAME, authentication.getUser().authenticatedUser().principal())).with(LoggingAuditTrail.PRINCIPAL_RUN_BY_REALM_FIELD_NAME, authentication.getAuthenticatedBy().getName());
            } else {
                this.logEntry.with(LoggingAuditTrail.PRINCIPAL_REALM_FIELD_NAME, authentication.getAuthenticatedBy().getName());
            }
            return this;
        }

        LogEntryBuilder with(String key, String value) {
            if (value != null) {
                this.logEntry.with(key, value);
            }
            return this;
        }

        LogEntryBuilder with(String key, String[] values) {
            if (values != null) {
                this.logEntry.with(key, this.toQuotedJsonArray(values));
            }
            return this;
        }

        LogEntryBuilder with(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value.getClass().isArray()) {
                    this.logEntry.with(entry.getKey(), this.toQuotedJsonArray((Object[])value));
                    continue;
                }
                this.logEntry.with(entry.getKey(), value);
            }
            return this;
        }

        StringMapMessage build() {
            return this.logEntry;
        }

        String toQuotedJsonArray(Object[] values) {
            assert (values != null);
            StringBuilder stringBuilder = new StringBuilder();
            JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
            stringBuilder.append("[");
            for (Object value : values) {
                if (value == null) continue;
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\"");
                jsonStringEncoder.quoteAsString((CharSequence)value.toString(), stringBuilder);
                stringBuilder.append("\"");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

