/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;

public class TransportHasPrivilegesAction
extends HandledTransportAction<HasPrivilegesRequest, HasPrivilegesResponse> {
    private final ThreadPool threadPool;
    private final AuthorizationService authorizationService;
    private final NativePrivilegeStore privilegeStore;
    private final SecurityContext securityContext;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportHasPrivilegesAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthorizationService authorizationService, NativePrivilegeStore privilegeStore, SecurityContext context, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/user/has_privileges", transportService, actionFilters, HasPrivilegesRequest::new);
        this.threadPool = threadPool;
        this.authorizationService = authorizationService;
        this.privilegeStore = privilegeStore;
        this.xContentRegistry = xContentRegistry;
        this.securityContext = context;
    }

    protected void doExecute(Task task, HasPrivilegesRequest request, ActionListener<HasPrivilegesResponse> listener) {
        String username = request.username();
        Authentication authentication = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext());
        User user = authentication.getUser();
        if (!user.principal().equals(username)) {
            listener.onFailure((Exception)new IllegalArgumentException("users may only check the privileges of their own account"));
            return;
        }
        RoleDescriptor.IndicesPrivileges[] indicesPrivileges = request.indexPrivileges();
        if (indicesPrivileges != null) {
            for (int i = 0; i < indicesPrivileges.length; ++i) {
                BytesReference query = indicesPrivileges[i].getQuery();
                if (query == null) continue;
                listener.onFailure((Exception)new IllegalArgumentException("users may only check the index privileges without any DLS role query"));
                return;
            }
        }
        this.resolveApplicationPrivileges(request, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(applicationPrivilegeDescriptors -> this.authorizationService.checkPrivileges(authentication, request, (Collection<ApplicationPrivilegeDescriptor>)applicationPrivilegeDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void resolveApplicationPrivileges(HasPrivilegesRequest request, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set<String> applications = TransportHasPrivilegesAction.getApplicationNames(request);
        this.privilegeStore.getPrivileges(applications, null, listener);
    }

    public static Set<String> getApplicationNames(HasPrivilegesRequest request) {
        return Arrays.stream(request.applicationPrivileges()).map(RoleDescriptor.ApplicationResourcePrivileges::getApplication).collect(Collectors.toSet());
    }
}

