/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportCreateApiKeyAction
extends HandledTransportAction<CreateApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public TransportCreateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/security/api_key/create", transportService, actionFilters, CreateApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else {
            this.rolesStore.getRoleDescriptors(new HashSet<String>(Arrays.asList(authentication.getUser().roles())), (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> {
                for (RoleDescriptor rd : roleDescriptors) {
                    try {
                        DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
                    }
                    catch (IllegalArgumentException | ElasticsearchException e) {
                        listener.onFailure((Exception)e);
                        return;
                    }
                }
                this.apiKeyService.createApiKey(authentication, request, (Set<RoleDescriptor>)roleDescriptors, listener);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

