/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.enrich;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.enrich.EnrichCoordinatorDoc;
import org.elasticsearch.xpack.monitoring.collector.enrich.ExecutingPolicyDoc;

public final class EnrichStatsCollector
extends Collector {
    public static final Setting<TimeValue> STATS_TIMEOUT = EnrichStatsCollector.collectionTimeoutSetting("enrich.stats.timeout");
    private final Client client;
    private final Settings settings;
    private final ThreadContext threadContext;

    public EnrichStatsCollector(ClusterService clusterService, XPackLicenseState licenseState, Client client, Settings settings) {
        this(clusterService, licenseState, client, client.threadPool().getThreadContext(), settings);
    }

    EnrichStatsCollector(ClusterService clusterService, XPackLicenseState licenseState, Client client, ThreadContext threadContext, Settings settings) {
        super("enrich_coordinator_stats", clusterService, STATS_TIMEOUT, licenseState);
        this.client = client;
        this.settings = settings;
        this.threadContext = threadContext;
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster) && (Boolean)XPackSettings.ENRICH_ENABLED_SETTING.get(this.settings) != false && this.licenseState.isEnrichAllowed();
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        try (ThreadContext.StoredContext ignore = this.threadContext.stashWithOrigin("monitoring");){
            long timestamp = EnrichStatsCollector.timestamp();
            String clusterUuid = EnrichStatsCollector.clusterUuid(clusterState);
            EnrichStatsAction.Request request = new EnrichStatsAction.Request();
            EnrichStatsAction.Response response = (EnrichStatsAction.Response)this.client.execute((ActionType)EnrichStatsAction.INSTANCE, (ActionRequest)request).actionGet(this.getCollectionTimeout());
            List<MonitoringDoc> docs = response.getCoordinatorStats().stream().map(stats -> new EnrichCoordinatorDoc(clusterUuid, timestamp, interval, node, (EnrichStatsAction.Response.CoordinatorStats)stats)).collect(Collectors.toList());
            response.getExecutingPolicies().stream().map(stats -> new ExecutingPolicyDoc(clusterUuid, timestamp, interval, node, (EnrichStatsAction.Response.ExecutingPolicy)stats)).forEach(docs::add);
            List<MonitoringDoc> list = docs;
            return list;
        }
    }
}

