/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetInfluencersAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetInfluencersAction.class));

    public RestGetInfluencersAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/influencers", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/influencers", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/influencers", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/influencers", deprecationLogger);
    }

    public String getName() {
        return "ml_get_influencers_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetInfluencersAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String start = restRequest.param(GetInfluencersAction.Request.START.getPreferredName());
        String end = restRequest.param(GetInfluencersAction.Request.END.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetInfluencersAction.Request.parseRequest((String)jobId, (XContentParser)parser);
        } else {
            request = new GetInfluencersAction.Request(jobId);
            request.setStart(start);
            request.setEnd(end);
            request.setExcludeInterim(restRequest.paramAsBoolean(GetInfluencersAction.Request.EXCLUDE_INTERIM.getPreferredName(), request.isExcludeInterim()));
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            request.setInfluencerScore(Double.parseDouble(restRequest.param(GetInfluencersAction.Request.INFLUENCER_SCORE.getPreferredName(), String.valueOf(request.getInfluencerScore()))));
            request.setSort(restRequest.param(GetInfluencersAction.Request.SORT_FIELD.getPreferredName(), request.getSort()));
            request.setDescending(restRequest.paramAsBoolean(GetInfluencersAction.Request.DESCENDING_SORT.getPreferredName(), request.isDescending()));
        }
        return channel -> client.execute((ActionType)GetInfluencersAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

