/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestPostDataAction
extends BaseRestHandler {
    private static final String DEFAULT_RESET_START = "";
    private static final String DEFAULT_RESET_END = "";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPostDataAction.class));

    public RestPostDataAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/_data", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/_data", deprecationLogger);
    }

    public String getName() {
        return "ml_post_data_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PostDataAction.Request request = new PostDataAction.Request(restRequest.param(Job.ID.getPreferredName()));
        request.setResetStart(restRequest.param(PostDataAction.Request.RESET_START.getPreferredName(), ""));
        request.setResetEnd(restRequest.param(PostDataAction.Request.RESET_END.getPreferredName(), ""));
        request.setContent(restRequest.content(), restRequest.getXContentType());
        return channel -> client.execute((ActionType)PostDataAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }

    public boolean supportsContentStream() {
        return true;
    }
}

