/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.dataframe;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;

public class RestGetDataFrameAnalyticsAction
extends BaseRestHandler {
    public RestGetDataFrameAnalyticsAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_ml/data_frame/analytics", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_ml/data_frame/analytics/{" + DataFrameAnalyticsConfig.ID.getPreferredName() + "}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_get_data_frame_analytics_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetDataFrameAnalyticsAction.Request request = new GetDataFrameAnalyticsAction.Request();
        String id = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        if (!Strings.isNullOrEmpty((String)id)) {
            request.setResourceId(id);
        }
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        request.setAllowNoResources(restRequest.paramAsBoolean(GetDataFrameAnalyticsAction.Request.ALLOW_NO_MATCH.getPreferredName(), request.isAllowNoResources()));
        return channel -> client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

