/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class RestGetDatafeedStatsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetDatafeedStatsAction.class));

    public RestGetDatafeedStatsAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stats", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stats", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/datafeeds/_stats", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/datafeeds/_stats", deprecationLogger);
    }

    public String getName() {
        return "ml_get_datafeed_stats_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)datafeedId)) {
            datafeedId = "_all";
        }
        GetDatafeedsStatsAction.Request request = new GetDatafeedsStatsAction.Request(datafeedId);
        request.setAllowNoDatafeeds(restRequest.paramAsBoolean(GetDatafeedsStatsAction.Request.ALLOW_NO_DATAFEEDS.getPreferredName(), request.allowNoDatafeeds()));
        return channel -> client.execute((ActionType)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

