/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class RestPostCalendarEventAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPostCalendarEventAction.class));

    public RestPostCalendarEventAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/calendars/{" + Calendar.ID.getPreferredName() + "}/events", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/calendars/{" + Calendar.ID.getPreferredName() + "}/events", deprecationLogger);
    }

    public String getName() {
        return "ml_post_calendar_event_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        XContentParser parser = restRequest.contentOrSourceParamParser();
        PostCalendarEventsAction.Request request = PostCalendarEventsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
        return channel -> client.execute((ActionType)PostCalendarEventsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

