/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;

public class JobResultsPersister {
    private static final Logger logger = LogManager.getLogger(JobResultsPersister.class);
    private final Client client;

    public JobResultsPersister(Client client) {
        this.client = client;
    }

    public Builder bulkPersisterBuilder(String jobId) {
        return new Builder(jobId);
    }

    public void persistCategoryDefinition(CategoryDefinition category) {
        Persistable persistable = new Persistable(category.getJobId(), (ToXContent)category, category.getId());
        persistable.persist(AnomalyDetectorsIndex.resultsWriteAlias((String)category.getJobId())).actionGet();
    }

    public void persistQuantiles(Quantiles quantiles) {
        Persistable persistable = new Persistable(quantiles.getJobId(), (ToXContent)quantiles, Quantiles.documentId((String)quantiles.getJobId()));
        persistable.persist(AnomalyDetectorsIndex.jobStateIndexWriteAlias()).actionGet();
    }

    public void persistQuantiles(Quantiles quantiles, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        Persistable persistable = new Persistable(quantiles.getJobId(), (ToXContent)quantiles, Quantiles.documentId((String)quantiles.getJobId()));
        persistable.setRefreshPolicy(refreshPolicy);
        persistable.persist(AnomalyDetectorsIndex.jobStateIndexWriteAlias(), listener);
    }

    public IndexResponse persistModelSnapshot(ModelSnapshot modelSnapshot, WriteRequest.RefreshPolicy refreshPolicy) {
        Persistable persistable = new Persistable(modelSnapshot.getJobId(), (ToXContent)modelSnapshot, ModelSnapshot.documentId((ModelSnapshot)modelSnapshot));
        persistable.setRefreshPolicy(refreshPolicy);
        return (IndexResponse)persistable.persist(AnomalyDetectorsIndex.resultsWriteAlias((String)modelSnapshot.getJobId())).actionGet();
    }

    public void persistModelSizeStats(ModelSizeStats modelSizeStats) {
        String jobId = modelSizeStats.getJobId();
        logger.trace("[{}] Persisting model size stats, for size {}", (Object)jobId, (Object)modelSizeStats.getModelBytes());
        Persistable persistable = new Persistable(jobId, (ToXContent)modelSizeStats, modelSizeStats.getId());
        persistable.persist(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)).actionGet();
    }

    public void persistModelSizeStats(ModelSizeStats modelSizeStats, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        String jobId = modelSizeStats.getJobId();
        logger.trace("[{}] Persisting model size stats, for size {}", (Object)jobId, (Object)modelSizeStats.getModelBytes());
        Persistable persistable = new Persistable(jobId, (ToXContent)modelSizeStats, modelSizeStats.getId());
        persistable.setRefreshPolicy(refreshPolicy);
        persistable.persist(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId), listener);
    }

    public void deleteInterimResults(String jobId) {
        new JobDataDeleter(this.client, jobId).deleteInterimResults();
    }

    public void commitResultWrites(String jobId) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        logger.trace("[{}] ES API CALL: refresh index {}", (Object)jobId, (Object)indexName);
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexName});
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.admin().indices().refresh(refreshRequest).actionGet();
        }
    }

    public void commitStateWrites(String jobId) {
        String indexName = AnomalyDetectorsIndex.jobStateIndexPattern();
        logger.trace("[{}] ES API CALL: refresh index {}", (Object)jobId, (Object)indexName);
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{indexName});
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            this.client.admin().indices().refresh(refreshRequest).actionGet();
        }
    }

    public IndexResponse persistDatafeedTimingStats(DatafeedTimingStats timingStats, WriteRequest.RefreshPolicy refreshPolicy) {
        String jobId = timingStats.getJobId();
        logger.trace("[{}] Persisting datafeed timing stats", (Object)jobId);
        Persistable persistable = new Persistable(jobId, (ToXContent)timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")), DatafeedTimingStats.documentId((String)timingStats.getJobId()));
        persistable.setRefreshPolicy(refreshPolicy);
        return (IndexResponse)persistable.persist(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)).actionGet();
    }

    private static XContentBuilder toXContentBuilder(ToXContent obj, ToXContent.Params params) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        obj.toXContent(builder, params);
        return builder;
    }

    private class Persistable {
        private final String jobId;
        private final ToXContent object;
        private final ToXContent.Params params;
        private final String id;
        private WriteRequest.RefreshPolicy refreshPolicy;

        Persistable(String jobId, ToXContent object, String id) {
            this(jobId, object, ToXContent.EMPTY_PARAMS, id);
        }

        Persistable(String jobId, ToXContent object, ToXContent.Params params, String id) {
            this.jobId = jobId;
            this.object = object;
            this.params = params;
            this.id = id;
            this.refreshPolicy = WriteRequest.RefreshPolicy.NONE;
        }

        void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
        }

        ActionFuture<IndexResponse> persist(String indexName) {
            PlainActionFuture actionFuture = PlainActionFuture.newFuture();
            this.persist(indexName, (ActionListener<IndexResponse>)actionFuture);
            return actionFuture;
        }

        void persist(String indexName, ActionListener<IndexResponse> listener) {
            this.logCall(indexName);
            try (XContentBuilder content = JobResultsPersister.toXContentBuilder(this.object, this.params);){
                IndexRequest indexRequest = (IndexRequest)new IndexRequest(indexName).id(this.id).source(content).setRefreshPolicy(this.refreshPolicy);
                ClientHelper.executeAsyncWithOrigin((ThreadContext)JobResultsPersister.this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)indexRequest, listener, (arg_0, arg_1) -> ((Client)JobResultsPersister.this.client).index(arg_0, arg_1));
            }
            catch (IOException e) {
                logger.error((Message)new ParameterizedMessage("[{}] Error writing [{}]", (Object)this.jobId, (Object)(this.id == null ? "auto-generated ID" : this.id)), (Throwable)e);
                IndexResponse.Builder notCreatedResponse = new IndexResponse.Builder();
                notCreatedResponse.setResult(DocWriteResponse.Result.NOOP);
                listener.onResponse((Object)notCreatedResponse.build());
            }
        }

        private void logCall(String indexName) {
            if (this.id != null) {
                logger.trace("[{}] ES API CALL: to index {} with ID [{}]", (Object)this.jobId, (Object)indexName, (Object)this.id);
            } else {
                logger.trace("[{}] ES API CALL: to index {} with auto-generated ID", (Object)this.jobId, (Object)indexName);
            }
        }
    }

    public class Builder {
        private BulkRequest bulkRequest;
        private final String jobId;
        private final String indexName;

        private Builder(String jobId) {
            this.jobId = Objects.requireNonNull(jobId);
            this.indexName = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
            this.bulkRequest = new BulkRequest();
        }

        public Builder persistBucket(Bucket bucket) {
            Bucket bucketWithoutRecords = bucket;
            if (!bucketWithoutRecords.getRecords().isEmpty()) {
                bucketWithoutRecords = new Bucket(bucket);
                bucketWithoutRecords.setRecords(Collections.emptyList());
            }
            String id = bucketWithoutRecords.getId();
            logger.trace("[{}] ES API CALL: index bucket to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)id);
            this.indexResult(id, (ToXContent)bucketWithoutRecords, "bucket");
            this.persistBucketInfluencersStandalone(this.jobId, bucketWithoutRecords.getBucketInfluencers());
            return this;
        }

        private void persistBucketInfluencersStandalone(String jobId, List<BucketInfluencer> bucketInfluencers) {
            if (bucketInfluencers != null && !bucketInfluencers.isEmpty()) {
                for (BucketInfluencer bucketInfluencer : bucketInfluencers) {
                    String id = bucketInfluencer.getId();
                    logger.trace("[{}] ES BULK ACTION: index bucket influencer to index [{}] with ID [{}]", (Object)jobId, (Object)this.indexName, (Object)id);
                    this.indexResult(id, (ToXContent)bucketInfluencer, "bucket influencer");
                }
            }
        }

        public Builder persistTimingStats(TimingStats timingStats) {
            this.indexResult(TimingStats.documentId((String)timingStats.getJobId()), (ToXContent)timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")), TimingStats.TYPE.getPreferredName());
            return this;
        }

        public Builder persistRecords(List<AnomalyRecord> records) {
            for (AnomalyRecord record : records) {
                logger.trace("[{}] ES BULK ACTION: index record to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)record.getId());
                this.indexResult(record.getId(), (ToXContent)record, "record");
            }
            return this;
        }

        public Builder persistInfluencers(List<Influencer> influencers) {
            for (Influencer influencer : influencers) {
                logger.trace("[{}] ES BULK ACTION: index influencer to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)influencer.getId());
                this.indexResult(influencer.getId(), (ToXContent)influencer, "influencer");
            }
            return this;
        }

        public Builder persistModelPlot(ModelPlot modelPlot) {
            logger.trace("[{}] ES BULK ACTION: index model plot to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)modelPlot.getId());
            this.indexResult(modelPlot.getId(), (ToXContent)modelPlot, "model plot");
            return this;
        }

        public Builder persistForecast(Forecast forecast) {
            logger.trace("[{}] ES BULK ACTION: index forecast to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)forecast.getId());
            this.indexResult(forecast.getId(), (ToXContent)forecast, "model_forecast");
            return this;
        }

        public Builder persistForecastRequestStats(ForecastRequestStats forecastRequestStats) {
            logger.trace("[{}] ES BULK ACTION: index forecast request stats to index [{}] with ID [{}]", (Object)this.jobId, (Object)this.indexName, (Object)forecastRequestStats.getId());
            this.indexResult(forecastRequestStats.getId(), (ToXContent)forecastRequestStats, "model_forecast");
            return this;
        }

        private void indexResult(String id, ToXContent resultDoc, String resultType) {
            this.indexResult(id, resultDoc, ToXContent.EMPTY_PARAMS, resultType);
        }

        private void indexResult(String id, ToXContent resultDoc, ToXContent.Params params, String resultType) {
            try (XContentBuilder content = JobResultsPersister.toXContentBuilder(resultDoc, params);){
                this.bulkRequest.add(new IndexRequest(this.indexName).id(id).source(content));
            }
            catch (IOException e) {
                logger.error((Message)new ParameterizedMessage("[{}] Error serialising {}", (Object)this.jobId, (Object)resultType), (Throwable)e);
            }
            if (this.bulkRequest.numberOfActions() >= 10000) {
                this.executeRequest();
            }
        }

        public void executeRequest() {
            if (this.bulkRequest.numberOfActions() == 0) {
                return;
            }
            logger.trace("[{}] ES API CALL: bulk request with {} actions", (Object)this.jobId, (Object)this.bulkRequest.numberOfActions());
            try (ThreadContext.StoredContext ignore = JobResultsPersister.this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
                BulkResponse addRecordsResponse = (BulkResponse)JobResultsPersister.this.client.bulk(this.bulkRequest).actionGet();
                if (addRecordsResponse.hasFailures()) {
                    logger.error("[{}] Bulk index of results has errors: {}", (Object)this.jobId, (Object)addRecordsResponse.buildFailureMessage());
                }
            }
            this.bulkRequest = new BulkRequest();
        }

        BulkRequest getBulkRequest() {
            return this.bulkRequest;
        }
    }
}

