/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;

public class JobDataCountsPersister {
    private static final Logger logger = LogManager.getLogger(JobDataCountsPersister.class);
    private final Client client;

    public JobDataCountsPersister(Client client) {
        this.client = client;
    }

    private XContentBuilder serialiseCounts(DataCounts counts) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        return counts.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public void persistDataCounts(String jobId, DataCounts counts, final ActionListener<Boolean> listener) {
        try (XContentBuilder content = this.serialiseCounts(counts);){
            IndexRequest request = new IndexRequest(AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)).id(DataCounts.documentId((String)jobId)).source(content);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    listener.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (IOException ioe) {
            logger.warn(() -> new ParameterizedMessage("[{}] Error serialising DataCounts stats", (Object)jobId), (Throwable)ioe);
        }
    }
}

