/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.persistence;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;

public final class InferenceInternalIndex {
    private InferenceInternalIndex() {
    }

    public static XContentBuilder mappings() throws IOException {
        return InferenceInternalIndex.configMapping("_doc");
    }

    public static IndexTemplateMetaData getIndexTemplateMetaData() throws IOException {
        IndexTemplateMetaData inferenceTemplate = IndexTemplateMetaData.builder((String)".ml-inference-000001").patterns(Collections.singletonList(".ml-inference-000001")).version(Integer.valueOf(Version.CURRENT.id)).settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1")).putMapping("_doc", Strings.toString((XContentBuilder)InferenceInternalIndex.mappings())).build();
        return inferenceTemplate;
    }

    public static XContentBuilder configMapping(String mappingType) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject(mappingType);
        ElasticsearchMappings.addMetaInformation((XContentBuilder)builder);
        builder.field("dynamic", "false");
        builder.startObject("properties");
        InferenceInternalIndex.addInferenceDocFields(builder);
        return builder.endObject().endObject().endObject();
    }

    private static void addInferenceDocFields(XContentBuilder builder) throws IOException {
        builder.startObject(TrainedModelConfig.MODEL_ID.getPreferredName()).field("type", "keyword").endObject().startObject(TrainedModelConfig.CREATED_BY.getPreferredName()).field("type", "keyword").endObject().startObject(TrainedModelConfig.VERSION.getPreferredName()).field("type", "keyword").endObject().startObject(TrainedModelConfig.DESCRIPTION.getPreferredName()).field("type", "text").endObject().startObject(TrainedModelConfig.CREATED_TIME.getPreferredName()).field("type", "date").endObject().startObject(TrainedModelConfig.MODEL_VERSION.getPreferredName()).field("type", "long").endObject().startObject(TrainedModelConfig.DEFINITION.getPreferredName()).field("enabled", false).endObject().startObject(TrainedModelConfig.MODEL_TYPE.getPreferredName()).field("type", "keyword").endObject().startObject(TrainedModelConfig.METADATA.getPreferredName()).field("enabled", false).endObject();
    }
}

