/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.AbstractField;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;

public class TimeField
extends AbstractField {
    static final String TYPE = "date";
    private static final Set<String> TYPES = Collections.singleton("date");
    private static final String EPOCH_MILLIS_FORMAT = "epoch_millis";
    private final ExtractedField.Method method;

    public TimeField(String name, ExtractedField.Method method) {
        super(name, TYPES);
        if (method == ExtractedField.Method.SOURCE) {
            throw new IllegalArgumentException("time field [" + name + "] cannot be extracted from source");
        }
        this.method = Objects.requireNonNull(method);
    }

    @Override
    public ExtractedField.Method getMethod() {
        return this.method;
    }

    @Override
    public Object[] value(SearchHit hit) {
        Object[] value = this.getFieldValue(hit);
        if (value.length != 1) {
            return value;
        }
        if (value[0] instanceof String) {
            value[0] = Long.parseLong((String)value[0]);
        } else if (!(value[0] instanceof Long)) {
            throw new IllegalStateException("Unexpected value for a time field: " + value[0].getClass());
        }
        return value;
    }

    @Override
    public String getDocValueFormat() {
        if (this.method != ExtractedField.Method.DOC_VALUE) {
            throw new UnsupportedOperationException();
        }
        return EPOCH_MILLIS_FORMAT;
    }

    @Override
    public boolean supportsFromSource() {
        return false;
    }

    @Override
    public ExtractedField newFromSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiField() {
        return false;
    }
}

