/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;

public class MultiField
implements ExtractedField {
    private final String name;
    private final String searchField;
    private final ExtractedField field;
    private final String parent;

    MultiField(String parent, ExtractedField field) {
        this(field.getName(), field.getSearchField(), parent, field);
    }

    MultiField(String name, String searchField, String parent, ExtractedField field) {
        this.name = Objects.requireNonNull(name);
        this.searchField = Objects.requireNonNull(searchField);
        this.field = Objects.requireNonNull(field);
        this.parent = Objects.requireNonNull(parent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSearchField() {
        return this.searchField;
    }

    @Override
    public Set<String> getTypes() {
        return this.field.getTypes();
    }

    @Override
    public ExtractedField.Method getMethod() {
        return this.field.getMethod();
    }

    @Override
    public Object[] value(SearchHit hit) {
        return this.field.value(hit);
    }

    @Override
    public boolean supportsFromSource() {
        return false;
    }

    @Override
    public ExtractedField newFromSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiField() {
        return true;
    }

    @Override
    public String getParentField() {
        return this.parent;
    }

    @Override
    public String getDocValueFormat() {
        return this.field.getDocValueFormat();
    }
}

