/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.DataFrameRowsJoiner;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.dataframe.process.results.RowResults;

public class AnalyticsResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(AnalyticsResultProcessor.class);
    private final String dataFrameAnalyticsId;
    private final DataFrameRowsJoiner dataFrameRowsJoiner;
    private final Supplier<Boolean> isProcessKilled;
    private final DataFrameAnalyticsTask.ProgressTracker progressTracker;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private volatile String failure;

    public AnalyticsResultProcessor(String dataFrameAnalyticsId, DataFrameRowsJoiner dataFrameRowsJoiner, Supplier<Boolean> isProcessKilled, DataFrameAnalyticsTask.ProgressTracker progressTracker) {
        this.dataFrameAnalyticsId = Objects.requireNonNull(dataFrameAnalyticsId);
        this.dataFrameRowsJoiner = Objects.requireNonNull(dataFrameRowsJoiner);
        this.isProcessKilled = Objects.requireNonNull(isProcessKilled);
        this.progressTracker = Objects.requireNonNull(progressTracker);
    }

    @Nullable
    public String getFailure() {
        return this.failure == null ? this.dataFrameRowsJoiner.getFailure() : this.failure;
    }

    public void awaitForCompletion() {
        try {
            this.completionLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Message)new ParameterizedMessage("[{}] Interrupted waiting for results processor to complete", (Object)this.dataFrameAnalyticsId), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AnalyticsProcess<AnalyticsResult> process) {
        long totalRows = process.getConfig().rows();
        long processedRows = 0L;
        try (DataFrameRowsJoiner resultsJoiner = this.dataFrameRowsJoiner;){
            Iterator<AnalyticsResult> iterator = process.readAnalyticsResults();
            while (iterator.hasNext()) {
                AnalyticsResult result = iterator.next();
                this.processResult(result, resultsJoiner);
                if (result.getRowResults() == null) continue;
                this.progressTracker.writingResultsPercent.set(++processedRows >= totalRows ? 100 : (int)((double)processedRows * 100.0 / (double)totalRows));
            }
            if (!this.isProcessKilled.get().booleanValue()) {
                this.progressTracker.writingResultsPercent.set(100);
            }
        }
        catch (Exception e) {
            if (this.isProcessKilled.get().booleanValue()) {
            } else {
                LOGGER.error((Message)new ParameterizedMessage("[{}] Error parsing data frame analytics output", (Object)this.dataFrameAnalyticsId), (Throwable)e);
                this.failure = "error parsing data frame analytics output: [" + e.getMessage() + "]";
            }
        }
        finally {
            this.completionLatch.countDown();
            process.consumeAndCloseOutputStream();
        }
    }

    private void processResult(AnalyticsResult result, DataFrameRowsJoiner resultsJoiner) {
        Integer progressPercent;
        RowResults rowResults = result.getRowResults();
        if (rowResults != null) {
            resultsJoiner.processRowResults(rowResults);
        }
        if ((progressPercent = result.getProgressPercent()) != null) {
            this.progressTracker.analyzingPercent.set(progressPercent);
        }
    }
}

