/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsControlMessageWriter;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.process.AbstractNativeProcess;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;

abstract class AbstractNativeAnalyticsProcess<Result>
extends AbstractNativeProcess
implements AnalyticsProcess<Result> {
    private final String name;
    private final ProcessResultsParser<Result> resultsParser;

    protected AbstractNativeAnalyticsProcess(String name, ConstructingObjectParser<Result, Void> resultParser, String jobId, InputStream logStream, OutputStream processInStream, InputStream processOutStream, OutputStream processRestoreStream, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash) {
        super(jobId, logStream, processInStream, processOutStream, processRestoreStream, numberOfFields, filesToDelete, onProcessCrash);
        this.name = Objects.requireNonNull(name);
        this.resultsParser = new ProcessResultsParser<Result>(Objects.requireNonNull(resultParser));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void persistState() {
    }

    @Override
    public void writeEndOfDataMessage() throws IOException {
        new AnalyticsControlMessageWriter(this.recordWriter(), this.numberOfFields()).writeEndOfData();
    }

    @Override
    public Iterator<Result> readAnalyticsResults() {
        return this.resultsParser.parseResults(this.processOutStream());
    }
}

