/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsIndex;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class DataFrameAnalyticsManager {
    private static final Logger LOGGER = LogManager.getLogger(DataFrameAnalyticsManager.class);
    private final NodeClient client;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final AnalyticsProcessManager processManager;
    private final DataFrameAnalyticsAuditor auditor;

    public DataFrameAnalyticsManager(NodeClient client, DataFrameAnalyticsConfigProvider configProvider, AnalyticsProcessManager processManager, DataFrameAnalyticsAuditor auditor) {
        this.client = Objects.requireNonNull(client);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.processManager = Objects.requireNonNull(processManager);
        this.auditor = Objects.requireNonNull(auditor);
    }

    public void execute(DataFrameAnalyticsTask task, DataFrameAnalyticsState currentState, ClusterState clusterState) {
        ActionListener configListener = ActionListener.wrap(config -> {
            switch (currentState) {
                case STARTED: {
                    this.executeStartingJob(task, (DataFrameAnalyticsConfig)config);
                    break;
                }
                case ANALYZING: {
                    LOGGER.debug("[{}] Reassigning job that was analyzing", (Object)config.getId());
                    this.startAnalytics(task, (DataFrameAnalyticsConfig)config, true);
                    break;
                }
                case REINDEXING: {
                    LOGGER.debug("[{}] Reassigning job that was reindexing", (Object)config.getId());
                    this.executeJobInMiddleOfReindexing(task, (DataFrameAnalyticsConfig)config);
                    break;
                }
                default: {
                    task.updateState(DataFrameAnalyticsState.FAILED, "Cannot execute analytics task [" + config.getId() + "] as it is in unknown state [" + currentState + "]. Must be one of [STARTED, REINDEXING, ANALYZING]");
                }
            }
        }, error -> task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage()));
        ActionListener stateAliasListener = ActionListener.wrap(aBoolean -> this.configProvider.get(task.getParams().getId(), (ActionListener<DataFrameAnalyticsConfig>)configListener), arg_0 -> ((ActionListener)configListener).onFailure(arg_0));
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)clusterState, (ActionListener)stateAliasListener);
    }

    private void executeStartingJob(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        DataFrameAnalyticsTaskState reindexingState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.REINDEXING, task.getAllocationId(), null);
        DataFrameAnalyticsTask.StartingState startingState = DataFrameAnalyticsTask.determineStartingState(config.getId(), task.getParams().getProgressOnStart());
        LOGGER.debug("[{}] Starting job from state [{}]", (Object)config.getId(), (Object)startingState);
        switch (startingState) {
            case FIRST_TIME: {
                task.updatePersistentTaskState((PersistentTaskState)reindexingState, ActionListener.wrap(updatedTask -> this.reindexDataframeAndStartAnalysis(task, config), error -> task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage())));
                break;
            }
            case RESUMING_REINDEXING: {
                task.updatePersistentTaskState((PersistentTaskState)reindexingState, ActionListener.wrap(updatedTask -> this.executeJobInMiddleOfReindexing(task, config), error -> task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage())));
                break;
            }
            case RESUMING_ANALYZING: {
                this.startAnalytics(task, config, true);
                break;
            }
            default: {
                task.updateState(DataFrameAnalyticsState.FAILED, "Unexpected starting state [" + (Object)((Object)startingState) + "]");
            }
        }
    }

    private void executeJobInMiddleOfReindexing(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteIndexAction.INSTANCE, (ActionRequest)new DeleteIndexRequest(config.getDest().getIndex()), (ActionListener)ActionListener.wrap(r -> this.reindexDataframeAndStartAnalysis(task, config), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                this.reindexDataframeAndStartAnalysis(task, config);
            } else {
                task.updateState(DataFrameAnalyticsState.FAILED, e.getMessage());
            }
        }));
    }

    private void reindexDataframeAndStartAnalysis(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        if (task.isStopping()) {
            task.markAsCompleted();
            return;
        }
        ActionListener reindexCompletedListener = ActionListener.wrap(refreshResponse -> {
            if (task.isStopping()) {
                LOGGER.debug("[{}] Stopping before starting analytics process", (Object)config.getId());
                return;
            }
            task.setReindexingTaskId(null);
            task.setReindexingFinished();
            this.auditor.info(config.getId(), Messages.getMessage((String)"Finished reindexing to destination index [{0}]", (Object[])new Object[]{config.getDest().getIndex()}));
            this.startAnalytics(task, config, false);
        }, error -> task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage()));
        ActionListener copyIndexCreatedListener = ActionListener.wrap(createIndexResponse -> {
            ReindexRequest reindexRequest = new ReindexRequest();
            reindexRequest.setSourceIndices(config.getSource().getIndex());
            reindexRequest.setSourceQuery(config.getSource().getParsedQuery());
            reindexRequest.setDestIndex(config.getDest().getIndex());
            reindexRequest.setScript(new Script("ctx._source.ml__id_copy = ctx._id"));
            ThreadContext threadContext = this.client.threadPool().getThreadContext();
            Supplier supplier = threadContext.newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin("ml");){
                Task reindexTask = this.client.executeLocally((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)new ContextPreservingActionListener(supplier, reindexCompletedListener));
                task.setReindexingTaskId(reindexTask.getId());
            }
        }, arg_0 -> ((ActionListener)reindexCompletedListener).onFailure(arg_0));
        ActionListener destIndexListener = ActionListener.wrap(indexResponse -> {
            this.auditor.info(config.getId(), Messages.getMessage((String)"Using existing destination index [{0}]", (Object[])new Object[]{indexResponse.indices()[0]}));
            LOGGER.info("[{}] Using existing destination index [{}]", (Object)config.getId(), (Object)indexResponse.indices()[0]);
            DataFrameAnalyticsIndex.updateMappingsToDestIndex((Client)this.client, config, indexResponse, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(acknowledgedResponse -> copyIndexCreatedListener.onResponse(null), arg_0 -> ((ActionListener)copyIndexCreatedListener).onFailure(arg_0)));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                this.auditor.info(config.getId(), Messages.getMessage((String)"Creating destination index [{0}]", (Object[])new Object[]{config.getDest().getIndex()}));
                LOGGER.info("[{}] Creating destination index [{}]", (Object)config.getId(), (Object)config.getDest().getIndex());
                DataFrameAnalyticsIndex.createDestinationIndex((Client)this.client, Clock.systemUTC(), config, (ActionListener<CreateIndexResponse>)copyIndexCreatedListener);
            } else {
                copyIndexCreatedListener.onFailure(e);
            }
        });
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)this.client, (ActionType)GetIndexAction.INSTANCE, (ActionRequest)((GetIndexRequest)new GetIndexRequest().indices(new String[]{config.getDest().getIndex()})), (ActionListener)destIndexListener);
    }

    private void startAnalytics(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, boolean isTaskRestarting) {
        task.setReindexingFinished();
        ActionListener dataExtractorFactoryListener = ActionListener.wrap(dataExtractorFactory -> {
            DataFrameAnalyticsTaskState analyzingState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.ANALYZING, task.getAllocationId(), null);
            task.updatePersistentTaskState((PersistentTaskState)analyzingState, ActionListener.wrap(updatedTask -> this.processManager.runJob(task, config, (DataFrameDataExtractorFactory)dataExtractorFactory, error -> {
                if (error != null) {
                    task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage());
                } else {
                    this.auditor.info(config.getId(), "Finished analysis");
                    task.markAsCompleted();
                }
            }), error -> {
                if (!(ExceptionsHelper.unwrapCause((Throwable)error) instanceof ResourceNotFoundException)) {
                    task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage());
                }
            }));
        }, error -> task.updateState(DataFrameAnalyticsState.FAILED, error.getMessage()));
        DataFrameDataExtractorFactory.createForDestinationIndex((Client)this.client, config, isTaskRestarting, (ActionListener<DataFrameDataExtractorFactory>)dataExtractorFactoryListener);
    }

    public void stop(DataFrameAnalyticsTask task) {
        this.processManager.stop(task);
    }
}

