/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;

public class DatafeedTimingStatsReporter {
    private DatafeedTimingStats persistedTimingStats;
    private volatile DatafeedTimingStats currentTimingStats;
    private final DatafeedTimingStatsPersister persister;
    private volatile boolean allowedPersisting;
    private static final double MIN_VALID_RATIO = 0.9;
    private static final double MAX_VALID_ABS_DIFFERENCE_MS = 10000.0;

    public DatafeedTimingStatsReporter(DatafeedTimingStats timingStats, DatafeedTimingStatsPersister persister) {
        Objects.requireNonNull(timingStats);
        this.persistedTimingStats = new DatafeedTimingStats(timingStats);
        this.currentTimingStats = new DatafeedTimingStats(timingStats);
        this.persister = Objects.requireNonNull(persister);
        this.allowedPersisting = true;
    }

    public DatafeedTimingStats getCurrentTimingStats() {
        return new DatafeedTimingStats(this.currentTimingStats);
    }

    public void reportSearchDuration(TimeValue searchDuration) {
        if (searchDuration == null) {
            return;
        }
        this.currentTimingStats.incrementSearchTimeMs((double)searchDuration.millis());
        this.flushIfDifferSignificantly();
    }

    public void reportDataCounts(DataCounts dataCounts) {
        if (dataCounts == null) {
            return;
        }
        this.currentTimingStats.incrementBucketCount(dataCounts.getBucketCount());
        if (dataCounts.getLatestRecordTimeStamp() != null) {
            this.currentTimingStats.setLatestRecordTimestamp(dataCounts.getLatestRecordTimeStamp().toInstant());
        }
        this.flushIfDifferSignificantly();
    }

    public void finishReporting() {
        if (!this.currentTimingStats.equals((Object)this.persistedTimingStats)) {
            this.flush(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
    }

    public void disallowPersisting() {
        this.allowedPersisting = false;
    }

    private void flushIfDifferSignificantly() {
        if (DatafeedTimingStatsReporter.differSignificantly(this.currentTimingStats, this.persistedTimingStats)) {
            this.flush(WriteRequest.RefreshPolicy.NONE);
        }
    }

    private void flush(WriteRequest.RefreshPolicy refreshPolicy) {
        this.persistedTimingStats = new DatafeedTimingStats(this.currentTimingStats);
        if (this.allowedPersisting) {
            this.persister.persistDatafeedTimingStats(this.persistedTimingStats, refreshPolicy);
        }
    }

    public static boolean differSignificantly(DatafeedTimingStats stats1, DatafeedTimingStats stats2) {
        return DatafeedTimingStatsReporter.countsDifferSignificantly(stats1.getSearchCount(), stats2.getSearchCount()) || DatafeedTimingStatsReporter.differSignificantly(stats1.getTotalSearchTimeMs(), stats2.getTotalSearchTimeMs()) || DatafeedTimingStatsReporter.differSignificantly(stats1.getAvgSearchTimePerBucketMs(), stats2.getAvgSearchTimePerBucketMs()) || DatafeedTimingStatsReporter.differSignificantly(stats1.getExponentialAvgSearchTimePerHourMs(), stats2.getExponentialAvgSearchTimePerHourMs());
    }

    private static boolean countsDifferSignificantly(long value1, long value2) {
        return (double)value2 / (double)value1 < 0.9 || (double)value1 / (double)value2 < 0.9;
    }

    private static boolean differSignificantly(Double value1, Double value2) {
        if (value1 != null && value2 != null) {
            return value2 / value1 < 0.9 || value1 / value2 < 0.9 || Math.abs(value1 - value2) > 10000.0;
        }
        return value1 != null || value2 != null;
    }

    @FunctionalInterface
    public static interface DatafeedTimingStatsPersister {
        public void persistDatafeedTimingStats(DatafeedTimingStats var1, WriteRequest.RefreshPolicy var2);
    }
}

