/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.EstimateMemoryUsageAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidator;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportStartDataFrameAnalyticsAction
extends TransportMasterNodeAction<StartDataFrameAnalyticsAction.Request, AcknowledgedResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportStartDataFrameAnalyticsAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final MlMemoryTracker memoryTracker;
    private final DataFrameAnalyticsAuditor auditor;

    @Inject
    public TransportStartDataFrameAnalyticsAction(TransportService transportService, Client client, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, DataFrameAnalyticsConfigProvider configProvider, MlMemoryTracker memoryTracker, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/start", transportService, clusterService, threadPool, actionFilters, StartDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.configProvider = configProvider;
        this.memoryTracker = memoryTracker;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(StartDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(final StartDataFrameAnalyticsAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        if (!this.licenseState.isMachineLearningAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>> waitForAnalyticsToStart = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task) {
                TransportStartDataFrameAnalyticsAction.this.waitForAnalyticsStarted((PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, request.getTimeout(), (ActionListener<AcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                    e = new ElasticsearchStatusException("Cannot start data frame analytics [" + request.getId() + "] because it has already been started", RestStatus.CONFLICT, e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }
        };
        ActionListener memoryUsageHandledListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(request, (ActionListener)waitForAnalyticsToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
        ActionListener startContextListener = ActionListener.wrap(startContext -> this.estimateMemoryUsageAndUpdateMemoryTracker((StartContext)startContext, (ActionListener<StartContext>)memoryUsageHandledListener), arg_0 -> listener.onFailure(arg_0));
        this.getStartContext(request.getId(), (ActionListener<StartContext>)startContextListener);
    }

    private void estimateMemoryUsageAndUpdateMemoryTracker(StartContext startContext, ActionListener<StartContext> listener) {
        String jobId = startContext.config.getId();
        ActionListener estimateMemoryUsageListener = ActionListener.wrap(estimateMemoryUsageResponse -> {
            this.auditor.info(jobId, Messages.getMessage((String)"Estimated memory usage for this analytics to be [{0}]", (Object[])new Object[]{estimateMemoryUsageResponse.getExpectedMemoryWithoutDisk()}));
            if (startContext.config.getModelMemoryLimit().compareTo(estimateMemoryUsageResponse.getExpectedMemoryWithoutDisk()) < 0) {
                ElasticsearchStatusException e = ExceptionsHelper.badRequestException((String)"Cannot start because the configured model memory limit [{}] is lower than the expected memory usage [{}]", (Object[])new Object[]{startContext.config.getModelMemoryLimit(), estimateMemoryUsageResponse.getExpectedMemoryWithoutDisk()});
                listener.onFailure((Exception)((Object)e));
                return;
            }
            this.memoryTracker.addDataFrameAnalyticsJobMemoryAndRefreshAllOthers(jobId, startContext.config.getModelMemoryLimit().getBytes(), (ActionListener<Void>)ActionListener.wrap(aVoid -> listener.onResponse((Object)startContext), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        PutDataFrameAnalyticsAction.Request estimateMemoryUsageRequest = new PutDataFrameAnalyticsAction.Request(startContext.config);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)EstimateMemoryUsageAction.INSTANCE, (ActionRequest)estimateMemoryUsageRequest, (ActionListener)estimateMemoryUsageListener);
    }

    private void getStartContext(String id, ActionListener<StartContext> finalListener) {
        ActionListener validateMappingsMergeListener = ActionListener.wrap(startContext -> DataFrameDataExtractorFactory.createForSourceIndices(this.client, "validate_source_index_has_rows-" + id, ((StartContext)startContext).config, (ActionListener<DataFrameDataExtractorFactory>)ActionListener.wrap(dataFrameDataExtractorFactory -> dataFrameDataExtractorFactory.newExtractor(false).collectDataSummaryAsync((ActionListener<DataFrameDataExtractor.DataSummary>)ActionListener.wrap(dataSummary -> {
            if (dataSummary.rows == 0L) {
                finalListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Unable to start {} as no documents in the source indices [{}] contained all the fields selected for analysis. If you are relying on automatic field selection then there are currently mapped fields that do not exist in any indexed documents, and you will have to switch to explicit field selection and include only fields that exist in indexed documents.", (Object[])new Object[]{id, Strings.arrayToCommaDelimitedString((Object[])((StartContext)startContext).config.getSource().getIndex())})));
            } else {
                finalListener.onResponse(startContext);
            }
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateMappingsListener = ActionListener.wrap(startContext -> MappingsMerger.mergeMappings(this.client, ((StartContext)startContext).config.getHeaders(), ((StartContext)startContext).config.getSource().getIndex(), (ActionListener<ImmutableOpenMap<String, MappingMetaData>>)ActionListener.wrap(mappings -> validateMappingsMergeListener.onResponse(startContext), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateDestEmptyListener = ActionListener.wrap(startContext -> {
            DataFrameAnalyticsTask.StartingState startingState = DataFrameAnalyticsTask.determineStartingState(((StartContext)startContext).config.getId(), ((StartContext)startContext).progressOnStart);
            switch (startingState) {
                case FIRST_TIME: {
                    this.checkDestIndexIsEmptyIfExists((StartContext)startContext, (ActionListener<StartContext>)toValidateMappingsListener);
                    break;
                }
                case RESUMING_REINDEXING: 
                case RESUMING_ANALYZING: {
                    toValidateMappingsListener.onResponse(startContext);
                    break;
                }
                case FINISHED: {
                    LOGGER.info("[{}] Job has already finished", (Object)((StartContext)startContext).config.getId());
                    finalListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Cannot start because the job has already finished", (Object[])new Object[0])));
                    break;
                }
                default: {
                    finalListener.onFailure((Exception)ExceptionsHelper.serverError((String)("Unexpected starting state " + (Object)((Object)startingState))));
                }
            }
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener startContextListener = ActionListener.wrap(startContext -> {
            new SourceDestValidator(this.clusterService.state(), this.indexNameExpressionResolver).check(((StartContext)startContext).config);
            DataFrameDataExtractorFactory.validateConfigAndSourceIndex(this.client, ((StartContext)startContext).config, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(config -> toValidateDestEmptyListener.onResponse(startContext), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getConfigListener = ActionListener.wrap(config -> this.getProgress((DataFrameAnalyticsConfig)config, (ActionListener<List<PhaseProgress>>)ActionListener.wrap(progress -> startContextListener.onResponse((Object)new StartContext((DataFrameAnalyticsConfig)config, (List)progress)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        this.configProvider.get(id, (ActionListener<DataFrameAnalyticsConfig>)getConfigListener);
    }

    private void getProgress(DataFrameAnalyticsConfig config, ActionListener<List<PhaseProgress>> listener) {
        GetDataFrameAnalyticsStatsAction.Request getStatsRequest = new GetDataFrameAnalyticsStatsAction.Request(config.getId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)getStatsRequest, (ActionListener)ActionListener.wrap(statsResponse -> {
            List stats = statsResponse.getResponse().results();
            if (stats.isEmpty()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingDataFrameAnalytics((String)config.getId())));
            } else {
                listener.onResponse((Object)((GetDataFrameAnalyticsStatsAction.Response.Stats)stats.get(0)).getProgress());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkDestIndexIsEmptyIfExists(StartContext startContext, ActionListener<StartContext> listener) {
        String destIndex = startContext.config.getDest().getIndex();
        SearchRequest destEmptySearch = new SearchRequest(new String[]{destIndex});
        destEmptySearch.source().size(0);
        destEmptySearch.allowPartialSearchResults(false);
        ClientHelper.executeWithHeadersAsync((Map)startContext.config.getHeaders(), (String)"ml", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)destEmptySearch, (ActionListener)ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"dest index [{}] must be empty", (Object[])new Object[]{destIndex})));
            } else {
                listener.onResponse((Object)startContext);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                listener.onResponse((Object)startContext);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void waitForAnalyticsStarted(final PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task, TimeValue timeout, final ActionListener<AcknowledgedResponse> listener) {
        final AnalyticsPredicate predicate = new AnalyticsPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(task.getId(), (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<PersistentTaskParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<PersistentTaskParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDataFrameAnalyticsAction.this.cancelAnalyticsStart((PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    TransportStartDataFrameAnalyticsAction.this.auditor.info(((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId(), "Started analytics");
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Starting data frame analytics [" + ((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void cancelAnalyticsStart(final PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                LOGGER.error("[" + ((StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams()).getId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, String ... indexNames) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
        String[] concreteIndices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), indexNames);
        ArrayList<String> unavailableIndices = new ArrayList<String>(concreteIndices.length);
        for (String index : concreteIndices) {
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private /* synthetic */ void lambda$masterOperation$0(StartDataFrameAnalyticsAction.Request request, ActionListener waitForAnalyticsToStart, StartContext startContext) throws Exception {
        StartDataFrameAnalyticsAction.TaskParams taskParams = new StartDataFrameAnalyticsAction.TaskParams(request.getId(), startContext.config.getVersion(), startContext.progressOnStart, startContext.config.isAllowLazyStart());
        this.persistentTasksService.sendStartRequest(MlTasks.dataFrameAnalyticsTaskId((String)request.getId()), "xpack/ml/data_frame/analytics", (PersistentTaskParams)taskParams, waitForAnalyticsToStart);
    }

    public static class TaskExecutor
    extends PersistentTasksExecutor<StartDataFrameAnalyticsAction.TaskParams> {
        private final Client client;
        private final ClusterService clusterService;
        private final DataFrameAnalyticsManager manager;
        private final DataFrameAnalyticsAuditor auditor;
        private final MlMemoryTracker memoryTracker;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile int maxOpenJobs;
        private volatile ClusterState clusterState;

        public TaskExecutor(Settings settings, Client client, ClusterService clusterService, DataFrameAnalyticsManager manager, DataFrameAnalyticsAuditor auditor, MlMemoryTracker memoryTracker) {
            super("xpack/ml/data_frame/analytics", "ml_utility");
            this.client = Objects.requireNonNull(client);
            this.clusterService = Objects.requireNonNull(clusterService);
            this.manager = Objects.requireNonNull(manager);
            this.auditor = Objects.requireNonNull(auditor);
            this.memoryTracker = Objects.requireNonNull(memoryTracker);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, Map<String, String> headers) {
            return new DataFrameAnalyticsTask(id, type, action, parentTaskId, headers, this.client, this.clusterService, this.manager, this.auditor, (StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams());
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(StartDataFrameAnalyticsAction.TaskParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String id = params.getId();
            List<String> unavailableIndices = TransportStartDataFrameAnalyticsAction.verifyIndicesPrimaryShardsAreActive(clusterState, AnomalyDetectorsIndex.configIndexName());
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening data frame analytics job [" + id + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                LOGGER.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening data frame analytics job [" + id + "] because job memory requirements are stale - refresh requested";
                LOGGER.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, id, "xpack/ml/data_frame/analytics", this.memoryTracker, params.isAllowLazyStart() ? Integer.MAX_VALUE : this.maxLazyMLNodes, node -> TaskExecutor.nodeFilter(node, id));
            return jobNodeSelector.selectNode(this.maxOpenJobs, Integer.MAX_VALUE, this.maxMachineMemoryPercent, isMemoryTrackerRecentlyRefreshed);
        }

        protected void nodeOperation(AllocatedPersistentTask task, StartDataFrameAnalyticsAction.TaskParams params, PersistentTaskState state) {
            LOGGER.info("[{}] Starting data frame analytics", (Object)params.getId());
            DataFrameAnalyticsTaskState analyticsTaskState = (DataFrameAnalyticsTaskState)state;
            if (analyticsTaskState != null && analyticsTaskState.getState().isAnyOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPING, DataFrameAnalyticsState.FAILED})) {
                return;
            }
            if (analyticsTaskState == null) {
                DataFrameAnalyticsTaskState startedState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.STARTED, task.getAllocationId(), null);
                task.updatePersistentTaskState((PersistentTaskState)startedState, ActionListener.wrap(response -> this.manager.execute((DataFrameAnalyticsTask)task, DataFrameAnalyticsState.STARTED, this.clusterState), arg_0 -> ((AllocatedPersistentTask)task).markAsFailed(arg_0)));
            } else {
                this.manager.execute((DataFrameAnalyticsTask)task, analyticsTaskState.getState(), this.clusterState);
            }
        }

        public static String nodeFilter(DiscoveryNode node, String id) {
            if (node.getVersion().before(StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED)) {
                return "Not opening job [" + id + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the data frame analytics requires a node of version [" + StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED + "] or higher";
            }
            return null;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            this.maxLazyMLNodes = maxLazyMLNodes;
        }

        void setMaxOpenJobs(int maxOpenJobs) {
            this.maxOpenJobs = maxOpenJobs;
        }
    }

    private static class AnalyticsPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile Exception exception;

        private AnalyticsPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                return true;
            }
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start data frame analytics task, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)persistentTask.getState();
            DataFrameAnalyticsState analyticsState = taskState == null ? DataFrameAnalyticsState.STOPPED : taskState.getState();
            switch (analyticsState) {
                case STARTED: 
                case REINDEXING: 
                case ANALYZING: {
                    return true;
                }
                case STOPPING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)"the task has been stopped while waiting to be started", (Object[])new Object[0]);
                    return true;
                }
                case STARTING: 
                case STOPPED: {
                    return false;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected task state [" + analyticsState + "] while waiting to be started"));
            return true;
        }
    }

    private static class StartContext {
        private final DataFrameAnalyticsConfig config;
        private final List<PhaseProgress> progressOnStart;

        private StartContext(DataFrameAnalyticsConfig config, List<PhaseProgress> progressOnStart) {
            this.config = config;
            this.progressOnStart = progressOnStart;
        }
    }
}

