/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class TransportGetJobsStatsAction
extends TransportTasksAction<TransportOpenJobAction.JobTask, GetJobsStatsAction.Request, GetJobsStatsAction.Response, QueryPage<GetJobsStatsAction.Response.JobStats>> {
    private final ClusterService clusterService;
    private final AutodetectProcessManager processManager;
    private final JobResultsProvider jobResultsProvider;
    private final JobConfigProvider jobConfigProvider;

    @Inject
    public TransportGetJobsStatsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, AutodetectProcessManager processManager, JobResultsProvider jobResultsProvider, JobConfigProvider jobConfigProvider) {
        super("cluster:monitor/xpack/ml/job/stats/get", clusterService, transportService, actionFilters, GetJobsStatsAction.Request::new, GetJobsStatsAction.Response::new, in -> new QueryPage(in, GetJobsStatsAction.Response.JobStats::new), "management");
        this.clusterService = clusterService;
        this.processManager = processManager;
        this.jobResultsProvider = jobResultsProvider;
        this.jobConfigProvider = jobConfigProvider;
    }

    protected void doExecute(Task task, GetJobsStatsAction.Request request, ActionListener<GetJobsStatsAction.Response> finalListener) {
        this.logger.debug("Get stats for job [{}]", (Object)request.getJobId());
        this.jobConfigProvider.expandJobsIds(request.getJobId(), request.allowNoJobs(), true, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedIds -> {
            request.setExpandedJobsIds(new ArrayList(expandedIds));
            ActionListener jobStatsListener = ActionListener.wrap(response -> this.gatherStatsForClosedJobs(request, (GetJobsStatsAction.Response)response, finalListener), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, jobStatsListener);
        }, arg_0 -> finalListener.onFailure(arg_0)));
    }

    protected GetJobsStatsAction.Response newResponse(GetJobsStatsAction.Request request, List<QueryPage<GetJobsStatsAction.Response.JobStats>> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        ArrayList stats = new ArrayList();
        for (QueryPage<GetJobsStatsAction.Response.JobStats> task : tasks) {
            stats.addAll(task.results());
        }
        Collections.sort(stats, Comparator.comparing(GetJobsStatsAction.Response.JobStats::getJobId));
        return new GetJobsStatsAction.Response(taskOperationFailures, failedNodeExceptions, new QueryPage(stats, (long)stats.size(), Job.RESULTS_FIELD));
    }

    protected void taskOperation(GetJobsStatsAction.Request request, TransportOpenJobAction.JobTask task, ActionListener<QueryPage<GetJobsStatsAction.Response.JobStats>> listener) {
        String jobId = task.getJobId();
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        Optional<Tuple<DataCounts, Tuple<ModelSizeStats, TimingStats>>> stats = this.processManager.getStatistics(task);
        if (stats.isPresent()) {
            DataCounts dataCounts = (DataCounts)stats.get().v1();
            ModelSizeStats modelSizeStats = (ModelSizeStats)((Tuple)stats.get().v2()).v1();
            TimingStats timingStats = (TimingStats)((Tuple)stats.get().v2()).v2();
            PersistentTasksCustomMetaData.PersistentTask pTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            DiscoveryNode node = state.nodes().get(pTask.getExecutorNode());
            JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetaData)tasks);
            String assignmentExplanation = pTask.getAssignment().getExplanation();
            TimeValue openTime = TransportGetJobsStatsAction.durationToTimeValue(this.processManager.jobOpenTime(task));
            this.gatherForecastStats(jobId, forecastStats -> {
                GetJobsStatsAction.Response.JobStats jobStats = new GetJobsStatsAction.Response.JobStats(jobId, dataCounts, modelSizeStats, forecastStats, jobState, node, assignmentExplanation, openTime, timingStats);
                listener.onResponse((Object)new QueryPage(Collections.singletonList(jobStats), 1L, Job.RESULTS_FIELD));
            }, arg_0 -> listener.onFailure(arg_0));
        } else {
            listener.onResponse((Object)new QueryPage(Collections.emptyList(), 0L, Job.RESULTS_FIELD));
        }
    }

    void gatherStatsForClosedJobs(GetJobsStatsAction.Request request, GetJobsStatsAction.Response response, ActionListener<GetJobsStatsAction.Response> listener) {
        List<String> closedJobIds = TransportGetJobsStatsAction.determineJobIdsWithoutLiveStats(request.getExpandedJobsIds(), response.getResponse().results());
        if (closedJobIds.isEmpty()) {
            listener.onResponse((Object)response);
            return;
        }
        AtomicInteger counter = new AtomicInteger(closedJobIds.size());
        AtomicArray jobStats = new AtomicArray(closedJobIds.size());
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        for (int i = 0; i < closedJobIds.size(); ++i) {
            int slot = i;
            String jobId = closedJobIds.get(i);
            this.gatherForecastStats(jobId, forecastStats -> this.gatherDataCountsModelSizeStatsAndTimingStats(jobId, (TriConsumer<DataCounts, ModelSizeStats, TimingStats>)((TriConsumer)(dataCounts, modelSizeStats, timingStats) -> {
                JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetaData)tasks);
                PersistentTasksCustomMetaData.PersistentTask pTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
                String assignmentExplanation = null;
                if (pTask != null) {
                    assignmentExplanation = pTask.getAssignment().getExplanation();
                }
                jobStats.set(slot, (Object)new GetJobsStatsAction.Response.JobStats(jobId, dataCounts, modelSizeStats, forecastStats, jobState, null, assignmentExplanation, null, timingStats));
                if (counter.decrementAndGet() == 0) {
                    List results = response.getResponse().results();
                    results.addAll(jobStats.asList());
                    Collections.sort(results, Comparator.comparing(GetJobsStatsAction.Response.JobStats::getJobId));
                    listener.onResponse((Object)new GetJobsStatsAction.Response(response.getTaskFailures(), response.getNodeFailures(), new QueryPage(results, (long)results.size(), Job.RESULTS_FIELD)));
                }
            }), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), arg_0 -> listener.onFailure(arg_0));
        }
    }

    void gatherForecastStats(String jobId, Consumer<ForecastStats> handler, Consumer<Exception> errorHandler) {
        this.jobResultsProvider.getForecastStats(jobId, handler, errorHandler);
    }

    void gatherDataCountsModelSizeStatsAndTimingStats(String jobId, TriConsumer<DataCounts, ModelSizeStats, TimingStats> handler, Consumer<Exception> errorHandler) {
        this.jobResultsProvider.dataCounts(jobId, dataCounts -> this.jobResultsProvider.modelSizeStats(jobId, modelSizeStats -> this.jobResultsProvider.timingStats(jobId, timingStats -> handler.apply(dataCounts, modelSizeStats, timingStats), errorHandler), errorHandler), errorHandler);
    }

    static TimeValue durationToTimeValue(Optional<Duration> duration) {
        if (duration.isPresent()) {
            return TimeValue.timeValueSeconds((long)duration.get().getSeconds());
        }
        return null;
    }

    static List<String> determineJobIdsWithoutLiveStats(List<String> requestedJobIds, List<GetJobsStatsAction.Response.JobStats> stats) {
        Set excludeJobIds = stats.stream().map(GetJobsStatsAction.Response.JobStats::getJobId).collect(Collectors.toSet());
        return requestedJobIds.stream().filter(jobId -> !excludeJobIds.contains(jobId)).collect(Collectors.toList());
    }
}

