/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetCategoriesAction
extends HandledTransportAction<GetCategoriesAction.Request, GetCategoriesAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final Client client;
    private final JobManager jobManager;

    @Inject
    public TransportGetCategoriesAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, Client client, JobManager jobManager) {
        super("cluster:monitor/xpack/ml/job/results/categories/get", transportService, actionFilters, GetCategoriesAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, GetCategoriesAction.Request request, ActionListener<GetCategoriesAction.Response> listener) {
        this.jobManager.jobExists(request.getJobId(), (ActionListener<Boolean>)ActionListener.wrap(jobExists -> {
            Integer from = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getFrom()) : null;
            Integer size = request.getPageParams() != null ? Integer.valueOf(request.getPageParams().getSize()) : null;
            this.jobResultsProvider.categoryDefinitions(request.getJobId(), request.getCategoryId(), true, from, size, r -> listener.onResponse((Object)new GetCategoriesAction.Response(r)), arg_0 -> ((ActionListener)listener).onFailure(arg_0), this.client);
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

