/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.utils.VoidChainTaskExecutor;

public class TransportFinalizeJobExecutionAction
extends TransportMasterNodeAction<FinalizeJobExecutionAction.Request, AcknowledgedResponse> {
    private final Client client;

    @Inject
    public TransportFinalizeJobExecutionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("cluster:internal/xpack/ml/job/finalize_job_execution", transportService, clusterService, threadPool, actionFilters, FinalizeJobExecutionAction.Request::new, indexNameExpressionResolver);
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(FinalizeJobExecutionAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String jobIdString = String.join((CharSequence)",", request.getJobIds());
        logger.debug("finalizing jobs [{}]", (Object)jobIdString);
        VoidChainTaskExecutor voidChainTaskExecutor = new VoidChainTaskExecutor(this.threadPool.executor("ml_utility"), true);
        Map<String, Date> update = Collections.singletonMap(Job.FINISHED_TIME.getPreferredName(), new Date());
        for (String jobId : request.getJobIds()) {
            UpdateRequest updateRequest = new UpdateRequest(AnomalyDetectorsIndex.configIndexName(), Job.documentId((String)jobId));
            updateRequest.retryOnConflict(3);
            updateRequest.doc(update);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            voidChainTaskExecutor.add(chainedListener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)UpdateAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> chainedListener.onResponse(null), arg_0 -> ((ActionListener)chainedListener).onFailure(arg_0))));
        }
        voidChainTaskExecutor.execute(ActionListener.wrap(aVoids -> {
            logger.debug("finalized job [{}]", (Object)jobIdString);
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(FinalizeJobExecutionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

