/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportEvaluateDataFrameAction
extends HandledTransportAction<EvaluateDataFrameAction.Request, EvaluateDataFrameAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;

    @Inject
    public TransportEvaluateDataFrameAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client) {
        super("cluster:monitor/xpack/ml/data_frame/evaluate", transportService, actionFilters, EvaluateDataFrameAction.Request::new);
        this.threadPool = threadPool;
        this.client = client;
    }

    protected void doExecute(Task task, EvaluateDataFrameAction.Request request, ActionListener<EvaluateDataFrameAction.Response> listener) {
        ActionListener resultsListener = ActionListener.wrap(unused -> {
            EvaluateDataFrameAction.Response response = new EvaluateDataFrameAction.Response(request.getEvaluation().getName(), request.getEvaluation().getResults());
            listener.onResponse((Object)response);
        }, arg_0 -> listener.onFailure(arg_0));
        EvaluationExecutor evaluationExecutor = new EvaluationExecutor(this.threadPool, this.client, request);
        evaluationExecutor.execute(resultsListener);
    }

    private static final class EvaluationExecutor
    extends TypedChainTaskExecutor<Void> {
        private final Client client;
        private final EvaluateDataFrameAction.Request request;
        private final Evaluation evaluation;

        EvaluationExecutor(ThreadPool threadPool, Client client, EvaluateDataFrameAction.Request request) {
            super(threadPool.generic(), (T unused) -> true, (Exception unused) -> true);
            this.client = client;
            this.request = request;
            this.evaluation = request.getEvaluation();
            this.add(this.nextTask());
        }

        private TypedChainTaskExecutor.ChainTask<Void> nextTask() {
            return listener -> {
                SearchSourceBuilder searchSourceBuilder = this.evaluation.buildSearch(this.request.getParsedQuery());
                SearchRequest searchRequest = new SearchRequest(this.request.getIndices()).source(searchSourceBuilder);
                this.client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> {
                    this.evaluation.process(searchResponse);
                    if (!this.evaluation.hasAllResults()) {
                        this.add(this.nextTask());
                    }
                    listener.onResponse(null);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            };
        }
    }
}

