/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.EstimateMemoryUsageAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.MemoryUsageEstimationProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.results.MemoryUsageEstimationResult;

public class TransportEstimateMemoryUsageAction
extends HandledTransportAction<PutDataFrameAnalyticsAction.Request, EstimateMemoryUsageAction.Response> {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final NodeClient client;
    private final MemoryUsageEstimationProcessManager processManager;

    @Inject
    public TransportEstimateMemoryUsageAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NodeClient client, MemoryUsageEstimationProcessManager processManager) {
        super("cluster:admin/xpack/ml/data_frame/analytics/estimate_memory_usage", transportService, actionFilters, PutDataFrameAnalyticsAction.Request::new);
        this.transportService = transportService;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.processManager = Objects.requireNonNull(processManager);
    }

    protected void doExecute(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<EstimateMemoryUsageAction.Response> listener) {
        DiscoveryNode localNode = this.clusterService.localNode();
        if (MachineLearning.isMlNode(localNode)) {
            this.doEstimateMemoryUsage(TransportEstimateMemoryUsageAction.createTaskIdForMemoryEstimation(task), request, listener);
        } else {
            this.redirectToMlNode(request, listener);
        }
    }

    private static String createTaskIdForMemoryEstimation(Task task) {
        return "memory_usage_estimation_" + task.getId();
    }

    private void doEstimateMemoryUsage(String taskId, PutDataFrameAnalyticsAction.Request request, ActionListener<EstimateMemoryUsageAction.Response> listener) {
        DataFrameDataExtractorFactory.createForSourceIndices((Client)this.client, taskId, request.getConfig(), (ActionListener<DataFrameDataExtractorFactory>)ActionListener.wrap(dataExtractorFactory -> this.processManager.runJobAsync(taskId, request.getConfig(), (DataFrameDataExtractorFactory)dataExtractorFactory, (ActionListener<MemoryUsageEstimationResult>)ActionListener.wrap(result -> listener.onResponse((Object)new EstimateMemoryUsageAction.Response(result.getExpectedMemoryWithoutDisk(), result.getExpectedMemoryWithDisk())), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void redirectToMlNode(PutDataFrameAnalyticsAction.Request request, ActionListener<EstimateMemoryUsageAction.Response> listener) {
        Optional<DiscoveryNode> node = TransportEstimateMemoryUsageAction.findMlNode(this.clusterService.state());
        if (node.isPresent()) {
            this.transportService.sendRequest(node.get(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, EstimateMemoryUsageAction.Response::new));
        } else {
            listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"No ML node to run on", (Object[])new Object[0])));
        }
    }

    private static Optional<DiscoveryNode> findMlNode(ClusterState clusterState) {
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!MachineLearning.isMlNode(node)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }
}

