/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class TransportDeleteModelSnapshotAction
extends HandledTransportAction<DeleteModelSnapshotAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;
    private final AnomalyDetectionAuditor auditor;

    @Inject
    public TransportDeleteModelSnapshotAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, Client client, JobManager jobManager, AnomalyDetectionAuditor auditor) {
        super("cluster:admin/xpack/ml/job/model_snapshots/delete", transportService, actionFilters, DeleteModelSnapshotAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
        this.auditor = auditor;
    }

    protected void doExecute(Task task, final DeleteModelSnapshotAction.Request request, final ActionListener<AcknowledgedResponse> listener) {
        this.jobResultsProvider.modelSnapshots(request.getJobId(), 0, 1, null, null, null, true, request.getSnapshotId(), page -> {
            List deleteCandidates = page.results();
            if (deleteCandidates.size() > 1) {
                this.logger.warn("More than one model found for [job_id: " + request.getJobId() + ", snapshot_id: " + request.getSnapshotId() + "] tuple.");
            }
            if (deleteCandidates.isEmpty()) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()}), new Object[0])));
                return;
            }
            final ModelSnapshot deleteCandidate = (ModelSnapshot)deleteCandidates.get(0);
            this.jobManager.getJob(request.getJobId(), (ActionListener<Job>)ActionListener.wrap(job -> {
                String currentModelInUse = job.getModelSnapshotId();
                if (currentModelInUse != null && currentModelInUse.equals(request.getSnapshotId())) {
                    listener.onFailure((Exception)new IllegalArgumentException(Messages.getMessage((String)"Model snapshot ''{0}'' is the active snapshot for job ''{1}'', so cannot be deleted", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()})));
                    return;
                }
                JobDataDeleter deleter = new JobDataDeleter(this.client, request.getJobId());
                deleter.deleteModelSnapshots(Collections.singletonList(deleteCandidate), new ActionListener<BulkByScrollResponse>(){

                    public void onResponse(BulkByScrollResponse bulkResponse) {
                        String msg = Messages.getMessage((String)"Model snapshot [{0}] with description ''{1}'' deleted", (Object[])new Object[]{deleteCandidate.getSnapshotId(), deleteCandidate.getDescription()});
                        TransportDeleteModelSnapshotAction.this.auditor.info(request.getJobId(), msg);
                        TransportDeleteModelSnapshotAction.this.logger.debug("[{}] {}", (Object)request.getJobId(), (Object)msg);
                        listener.onResponse((Object)new AcknowledgedResponse(true));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

