/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class TransportDeleteDataFrameAnalyticsAction
extends TransportMasterNodeAction<DeleteDataFrameAnalyticsAction.Request, AcknowledgedResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportDeleteDataFrameAnalyticsAction.class);
    private final Client client;
    private final MlMemoryTracker memoryTracker;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final DataFrameAnalyticsAuditor auditor;

    @Inject
    public TransportDeleteDataFrameAnalyticsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, MlMemoryTracker memoryTracker, DataFrameAnalyticsConfigProvider configProvider, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.memoryTracker = memoryTracker;
        this.configProvider = configProvider;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    protected void masterOperation(Task task, DeleteDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetaData tasks;
        String id = request.getId();
        DataFrameAnalyticsState taskState = MlTasks.getDataFrameAnalyticsState((String)id, (PersistentTasksCustomMetaData)(tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks")));
        if (taskState != DataFrameAnalyticsState.STOPPED) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot delete data frame analytics [{}] while its status is [{}]", (Object[])new Object[]{id, taskState})));
            return;
        }
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        this.memoryTracker.removeDataFrameAnalyticsJob(id);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                LOGGER.warn("[{}] DeleteByQuery for state timed out", (Object)id);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                LOGGER.warn("[{}] {} failures and {} conflicts encountered while runnint DeleteByQuery for state", (Object)id, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts());
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    LOGGER.warn("[{}] DBQ failure: {}", (Object)id, (Object)failure);
                }
            }
            this.deleteConfig(parentTaskClient, id, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener configListener = ActionListener.wrap(config -> this.deleteState(parentTaskClient, (DataFrameAnalyticsConfig)config, (ActionListener<BulkByScrollResponse>)deleteStateHandler), arg_0 -> listener.onFailure(arg_0));
        this.configProvider.get(id, (ActionListener<DataFrameAnalyticsConfig>)configListener);
    }

    private void deleteConfig(ParentTaskAssigningClient parentTaskClient, String id, ActionListener<AcknowledgedResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(AnomalyDetectorsIndex.configIndexName());
        deleteRequest.id(DataFrameAnalyticsConfig.documentId((String)id));
        deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)DeleteAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)ActionListener.wrap(deleteResponse -> {
            if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingDataFrameAnalytics((String)id)));
                return;
            }
            assert (deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
            LOGGER.info("[{}] Deleted", (Object)id);
            this.auditor.info(id, "Deleted analytics");
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void deleteState(ParentTaskAssigningClient parentTaskClient, DataFrameAnalyticsConfig config, ActionListener<BulkByScrollResponse> listener) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(DataFrameAnalyticsTask.progressDocId(config.getId()));
        if (config.getAnalysis().persistsState()) {
            ids.add(config.getAnalysis().getStateDocId(config.getId()));
        }
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()});
        request.setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[0])));
        request.setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setSlices(0);
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
    }

    protected ClusterBlockException checkBlock(DeleteDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

