/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ml.MachineLearningFeatureSet;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;

public class MlLifeCycleService {
    private final Environment environment;
    private final ClusterService clusterService;
    private final DatafeedManager datafeedManager;
    private final AutodetectProcessManager autodetectProcessManager;
    private final MlMemoryTracker memoryTracker;

    public MlLifeCycleService(Environment environment, ClusterService clusterService, DatafeedManager datafeedManager, AutodetectProcessManager autodetectProcessManager, MlMemoryTracker memoryTracker) {
        this.environment = environment;
        this.clusterService = clusterService;
        this.datafeedManager = datafeedManager;
        this.autodetectProcessManager = autodetectProcessManager;
        this.memoryTracker = memoryTracker;
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                MlLifeCycleService.this.stop();
            }
        });
    }

    public synchronized void stop() {
        try {
            if (MachineLearningFeatureSet.isRunningOnMlPlatform(false)) {
                NativeController nativeController;
                if (this.datafeedManager != null) {
                    this.datafeedManager.isolateAllDatafeedsOnThisNodeBeforeShutdown();
                }
                if ((nativeController = NativeControllerHolder.getNativeController(this.clusterService.getNodeName(), this.environment)) != null) {
                    if (this.autodetectProcessManager != null) {
                        this.autodetectProcessManager.killAllProcessesOnThisNode();
                    }
                    nativeController.stop();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.memoryTracker != null) {
            this.memoryTracker.stop();
        }
    }
}

