/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlDailyMaintenanceService;

class MlInitializationService
implements LocalNodeMasterListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlInitializationService.class);
    private final Settings settings;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final Client client;
    private final MlAssignmentNotifier mlAssignmentNotifier;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);
    private volatile MlDailyMaintenanceService mlDailyMaintenanceService;

    MlInitializationService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client, MlAssignmentNotifier mlAssignmentNotifier) {
        this.settings = Objects.requireNonNull(settings);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.mlAssignmentNotifier = Objects.requireNonNull(mlAssignmentNotifier);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
    }

    public void onMaster() {
        this.installDailyMaintenanceService();
    }

    public void offMaster() {
        this.uninstallDailyMaintenanceService();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (event.localNodeMaster() && this.isIndexCreationInProgress.compareAndSet(false, true)) {
            AnnotationIndex.createAnnotationsIndexIfNecessary((Settings)this.settings, (Client)this.client, (ClusterState)event.state(), (ActionListener)ActionListener.wrap(r -> {
                this.isIndexCreationInProgress.set(false);
                if (r.booleanValue()) {
                    logger.info("Created ML annotations index and aliases");
                }
            }, e -> {
                this.isIndexCreationInProgress.set(false);
                logger.error("Error creating ML annotations index or aliases", (Throwable)e);
            }));
        }
    }

    public String executorName() {
        return "generic";
    }

    private synchronized void installDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService == null) {
            this.mlDailyMaintenanceService = new MlDailyMaintenanceService(this.clusterService.getClusterName(), this.threadPool, this.client, this.clusterService, this.mlAssignmentNotifier);
            this.mlDailyMaintenanceService.start();
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    MlInitializationService.this.uninstallDailyMaintenanceService();
                }
            });
        }
    }

    private synchronized void uninstallDailyMaintenanceService() {
        if (this.mlDailyMaintenanceService != null) {
            this.mlDailyMaintenanceService.stop();
            this.mlDailyMaintenanceService = null;
        }
    }

    MlDailyMaintenanceService getDailyMaintenanceService() {
        return this.mlDailyMaintenanceService;
    }

    synchronized void setDailyMaintenanceService(MlDailyMaintenanceService service) {
        this.mlDailyMaintenanceService = service;
    }
}

