/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;

public class MlDailyMaintenanceService
implements Releasable {
    private static final Logger LOGGER = LogManager.getLogger(MlDailyMaintenanceService.class);
    private static final int MAX_TIME_OFFSET_MINUTES = 120;
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final MlAssignmentNotifier mlAssignmentNotifier;
    private final Supplier<TimeValue> schedulerProvider;
    private volatile Scheduler.Cancellable cancellable;

    MlDailyMaintenanceService(ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, Supplier<TimeValue> scheduleProvider) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.mlAssignmentNotifier = Objects.requireNonNull(mlAssignmentNotifier);
        this.schedulerProvider = Objects.requireNonNull(scheduleProvider);
    }

    public MlDailyMaintenanceService(ClusterName clusterName, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier) {
        this(threadPool, client, clusterService, mlAssignmentNotifier, () -> MlDailyMaintenanceService.delayToNextTime(clusterName));
    }

    private static TimeValue delayToNextTime(ClusterName clusterName) {
        Random random = new Random(clusterName.hashCode());
        int minutesOffset = random.ints(0, 120).findFirst().getAsInt();
        ZonedDateTime now = ZonedDateTime.now(Clock.systemDefaultZone());
        ZonedDateTime next = now.plusDays(1L).toLocalDate().atStartOfDay(now.getZone()).plusMinutes(30L).plusMinutes(minutesOffset);
        return TimeValue.timeValueMillis((long)(next.toInstant().toEpochMilli() - now.toInstant().toEpochMilli()));
    }

    public synchronized void start() {
        LOGGER.debug("Starting ML daily maintenance service");
        this.scheduleNext();
    }

    public synchronized void stop() {
        LOGGER.debug("Stopping ML daily maintenance service");
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.cancellable.cancel();
        }
    }

    public boolean isStarted() {
        return this.cancellable != null;
    }

    public void close() {
        this.stop();
    }

    private synchronized void scheduleNext() {
        try {
            this.cancellable = this.threadPool.schedule(this::triggerTasks, this.schedulerProvider.get(), "generic");
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                LOGGER.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    private void triggerTasks() {
        try {
            LOGGER.info("triggering scheduled [ML] maintenance tasks");
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteExpiredDataAction.INSTANCE, (ActionRequest)new DeleteExpiredDataAction.Request(), (ActionListener)ActionListener.wrap(response -> {
                if (response.isDeleted()) {
                    LOGGER.info("Successfully completed [ML] maintenance tasks");
                } else {
                    LOGGER.info("Halting [ML] maintenance tasks before completion as elapsed time is too great");
                }
            }, e -> LOGGER.error("An error occurred during maintenance tasks execution", (Throwable)e)));
            this.auditUnassignedMlTasks(this.clusterService.state());
        }
        finally {
            this.scheduleNext();
        }
    }

    private void auditUnassignedMlTasks(ClusterState state) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (tasks != null) {
            this.mlAssignmentNotifier.auditUnassignedMlTasks(state.nodes(), tasks);
        }
    }
}

