/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;

public class UpdateSnapshotLifecycleStatsTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionTask.class);
    private final SnapshotLifecycleStats runStats;

    UpdateSnapshotLifecycleStatsTask(SnapshotLifecycleStats runStats) {
        this.runStats = runStats;
    }

    public ClusterState execute(ClusterState currentState) {
        MetaData currentMeta = currentState.metaData();
        SnapshotLifecycleMetadata currentSlmMeta = (SnapshotLifecycleMetadata)currentMeta.custom("snapshot_lifecycle");
        if (currentSlmMeta == null) {
            return currentState;
        }
        SnapshotLifecycleStats newMetrics = currentSlmMeta.getStats().merge(this.runStats);
        SnapshotLifecycleMetadata newSlmMeta = new SnapshotLifecycleMetadata(currentSlmMeta.getSnapshotConfigurations(), currentSlmMeta.getOperationMode(), newMetrics);
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentMeta).putCustom("snapshot_lifecycle", (MetaData.Custom)newSlmMeta)).build();
    }

    public void onFailure(String source, Exception e) {
        logger.error((Message)new ParameterizedMessage("failed to update cluster state with snapshot lifecycle stats, source: [{}], missing stats: [{}]", (Object)source, (Object)this.runStats), (Throwable)e);
    }
}

