/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.slm.SLMFeatureSetUsage;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class SLMFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private ClusterService clusterService;

    @Inject
    public SLMFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.enabled = (Boolean)XPackSettings.SNAPSHOT_LIFECYCLE_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "slm";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isIndexLifecycleAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        boolean available = this.licenseState.isIndexLifecycleAllowed();
        SnapshotLifecycleMetadata slmMeta = (SnapshotLifecycleMetadata)state.metaData().custom("snapshot_lifecycle");
        SLMFeatureSetUsage usage = new SLMFeatureSetUsage(available, this.enabled, slmMeta == null ? null : slmMeta.getStats());
        listener.onResponse((Object)usage);
    }
}

