/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;

public class TransportPutLifecycleAction
extends TransportMasterNodeAction<PutLifecycleAction.Request, PutLifecycleAction.Response> {
    @Inject
    public TransportPutLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/put", transportService, clusterService, threadPool, actionFilters, PutLifecycleAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected PutLifecycleAction.Response read(StreamInput in) throws IOException {
        return new PutLifecycleAction.Response(in);
    }

    protected void masterOperation(final PutLifecycleAction.Request request, ClusterState state, ActionListener<PutLifecycleAction.Response> listener) {
        final Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LifecyclePolicy.validatePolicyName((String)request.getPolicy().getName());
        this.clusterService.submitStateUpdateTask("put-lifecycle-" + request.getPolicy().getName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutLifecycleAction.Response>((AckedRequest)request, listener){

            protected PutLifecycleAction.Response newResponse(boolean acknowledged) {
                return new PutLifecycleAction.Response(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                LifecyclePolicyMetadata lifecyclePolicyMetadata;
                LifecyclePolicyMetadata existingPolicyMetadata;
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metaData().custom("index_lifecycle");
                if (currentMetadata == null) {
                    currentMetadata = IndexLifecycleMetadata.EMPTY;
                }
                long nextVersion = (existingPolicyMetadata = (LifecyclePolicyMetadata)currentMetadata.getPolicyMetadatas().get(request.getPolicy().getName())) == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
                TreeMap<String, LifecyclePolicyMetadata> newPolicies = new TreeMap<String, LifecyclePolicyMetadata>(currentMetadata.getPolicyMetadatas());
                LifecyclePolicyMetadata oldPolicy = newPolicies.put((lifecyclePolicyMetadata = new LifecyclePolicyMetadata(request.getPolicy(), filteredHeaders, nextVersion, Instant.now().toEpochMilli())).getName(), lifecyclePolicyMetadata);
                if (oldPolicy == null) {
                    logger.info("adding index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                } else {
                    logger.info("updating index lifecycle policy [{}]", (Object)request.getPolicy().getName());
                }
                IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentMetadata.getOperationMode());
                newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("index_lifecycle", (MetaData.Custom)newMetadata).build());
                return newState.build();
            }
        });
    }

    protected ClusterBlockException checkBlock(PutLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

