/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleExplainResponse;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportExplainLifecycleAction
extends TransportClusterInfoAction<ExplainLifecycleRequest, ExplainLifecycleResponse> {
    private final NamedXContentRegistry xContentRegistry;
    private final IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportExplainLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/explain", transportService, clusterService, threadPool, actionFilters, ExplainLifecycleRequest::new, indexNameExpressionResolver);
        this.xContentRegistry = xContentRegistry;
        this.indexLifecycleService = indexLifecycleService;
    }

    protected String executor() {
        return "same";
    }

    protected ExplainLifecycleResponse read(StreamInput in) throws IOException {
        return new ExplainLifecycleResponse(in);
    }

    protected ClusterBlockException checkBlock(ExplainLifecycleRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected void doMasterOperation(ExplainLifecycleRequest request, String[] concreteIndices, ClusterState state, ActionListener<ExplainLifecycleResponse> listener) {
        HashMap<String, IndexLifecycleExplainResponse> indexResponses = new HashMap<String, IndexLifecycleExplainResponse>();
        for (String index : concreteIndices) {
            Long originationDate;
            IndexMetaData idxMetadata = state.metaData().index(index);
            Settings idxSettings = idxMetadata.getSettings();
            LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetaData)idxMetadata);
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxSettings);
            String currentPhase = lifecycleState.getPhase();
            String stepInfo = lifecycleState.getStepInfo();
            BytesArray stepInfoBytes = null;
            if (stepInfo != null) {
                stepInfoBytes = new BytesArray(stepInfo);
            }
            String phaseDef = lifecycleState.getPhaseDefinition();
            PhaseExecutionInfo phaseExecutionInfo = null;
            if (!Strings.isNullOrEmpty((String)phaseDef)) {
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
                    phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
                }
                catch (IOException e) {
                    listener.onFailure((Exception)new ElasticsearchParseException("failed to parse phase definition for index [" + index + "]", (Throwable)e, new Object[0]));
                    return;
                }
            }
            Object indexResponse = Strings.hasLength((String)policyName) ? (!request.onlyErrors() || "ERROR".equals(lifecycleState.getStep()) || !this.indexLifecycleService.policyExists(policyName) ? IndexLifecycleExplainResponse.newManagedIndexResponse((String)index, (String)policyName, (Long)((originationDate = idxSettings.getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L))) != -1L ? originationDate : lifecycleState.getLifecycleDate()), (String)lifecycleState.getPhase(), (String)lifecycleState.getAction(), (String)lifecycleState.getStep(), (String)lifecycleState.getFailedStep(), (Long)lifecycleState.getPhaseTime(), (Long)lifecycleState.getActionTime(), (Long)lifecycleState.getStepTime(), (BytesReference)stepInfoBytes, (PhaseExecutionInfo)phaseExecutionInfo) : null) : (!request.onlyManaged() && !request.onlyErrors() ? IndexLifecycleExplainResponse.newUnmanagedIndexResponse((String)index) : null);
            if (indexResponse == null) continue;
            indexResponses.put(indexResponse.getIndex(), (IndexLifecycleExplainResponse)indexResponse);
        }
        listener.onResponse((Object)new ExplainLifecycleResponse(indexResponses));
    }
}

