/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;

public class RestExplainLifecycleAction
extends BaseRestHandler {
    public RestExplainLifecycleAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_ilm/explain", (RestHandler)this);
    }

    public String getName() {
        return "ilm_explain_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String[] indexes = Strings.splitStringByCommaToArray((String)restRequest.param("index"));
        ExplainLifecycleRequest explainLifecycleRequest = new ExplainLifecycleRequest();
        explainLifecycleRequest.indices(indexes);
        explainLifecycleRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)IndicesOptions.strictExpandOpen()));
        explainLifecycleRequest.onlyManaged(restRequest.paramAsBoolean("only_managed", false));
        explainLifecycleRequest.onlyErrors(restRequest.paramAsBoolean("only_errors", false));
        String masterNodeTimeout = restRequest.param("master_timeout");
        if (masterNodeTimeout != null) {
            explainLifecycleRequest.masterNodeTimeout(masterNodeTimeout);
        }
        return channel -> client.execute((ActionType)ExplainLifecycleAction.INSTANCE, (ActionRequest)explainLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

