/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    @Nullable
    private final OperationMode ilmMode;
    @Nullable
    private final OperationMode slmMode;

    private OperationModeUpdateTask(OperationMode ilmMode, OperationMode slmMode) {
        this.ilmMode = ilmMode;
        this.slmMode = slmMode;
    }

    public static OperationModeUpdateTask ilmMode(OperationMode mode) {
        return new OperationModeUpdateTask(mode, null);
    }

    public static OperationModeUpdateTask slmMode(OperationMode mode) {
        return new OperationModeUpdateTask(null, mode);
    }

    OperationMode getILMOperationMode() {
        return this.ilmMode;
    }

    OperationMode getSLMOperationMode() {
        return this.slmMode;
    }

    public ClusterState execute(ClusterState currentState) {
        ClusterState newState = currentState;
        newState = this.updateILMState(newState);
        newState = this.updateSLMState(newState);
        return newState;
    }

    private ClusterState updateILMState(ClusterState currentState) {
        OperationMode newMode;
        if (this.ilmMode == null) {
            return currentState;
        }
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metaData().custom("index_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.ilmMode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = IndexLifecycleMetadata.EMPTY;
        }
        if (!(newMode = currentMetadata.getOperationMode().isValidChange(this.ilmMode) ? this.ilmMode : currentMetadata.getOperationMode()).equals((Object)this.ilmMode)) {
            logger.info("updating ILM operation mode to {}", (Object)newMode);
        }
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).putCustom("index_lifecycle", (MetaData.Custom)new IndexLifecycleMetadata(currentMetadata.getPolicyMetadatas(), newMode))).build();
    }

    private ClusterState updateSLMState(ClusterState currentState) {
        OperationMode newMode;
        if (this.slmMode == null) {
            return currentState;
        }
        SnapshotLifecycleMetadata currentMetadata = (SnapshotLifecycleMetadata)currentState.metaData().custom("snapshot_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.slmMode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = SnapshotLifecycleMetadata.EMPTY;
        }
        if (!(newMode = currentMetadata.getOperationMode().isValidChange(this.slmMode) ? this.slmMode : currentMetadata.getOperationMode()).equals((Object)this.slmMode)) {
            logger.info("updating SLM operation mode to {}", (Object)newMode);
        }
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).putCustom("snapshot_lifecycle", (MetaData.Custom)new SnapshotLifecycleMetadata(currentMetadata.getSnapshotConfigurations(), newMode, currentMetadata.getStats()))).build();
    }

    public void onFailure(String source, Exception e) {
        logger.error("unable to update lifecycle metadata with new ilm mode [" + this.ilmMode + "], slm mode [" + this.slmMode + "]", (Throwable)e);
    }
}

