/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.FreezeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;
import org.elasticsearch.xpack.core.ilm.action.MoveToStepAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.core.ilm.action.StartILMAction;
import org.elasticsearch.xpack.core.ilm.action.StopILMAction;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.core.slm.action.GetSLMStatusAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.StartSLMAction;
import org.elasticsearch.xpack.core.slm.action.StopSLMAction;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.core.slm.history.SnapshotLifecycleTemplateRegistry;
import org.elasticsearch.xpack.ilm.IndexLifecycleFeatureSet;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;
import org.elasticsearch.xpack.ilm.action.RestDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetStatusAction;
import org.elasticsearch.xpack.ilm.action.RestMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.RestPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.RestRetryAction;
import org.elasticsearch.xpack.ilm.action.RestStartILMAction;
import org.elasticsearch.xpack.ilm.action.RestStopAction;
import org.elasticsearch.xpack.ilm.action.TransportDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetStatusAction;
import org.elasticsearch.xpack.ilm.action.TransportMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.TransportPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.TransportRetryAction;
import org.elasticsearch.xpack.ilm.action.TransportStartILMAction;
import org.elasticsearch.xpack.ilm.action.TransportStopILMAction;
import org.elasticsearch.xpack.slm.SLMFeatureSet;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;
import org.elasticsearch.xpack.slm.SnapshotRetentionService;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;
import org.elasticsearch.xpack.slm.action.RestDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.RestGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.RestPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestStartSLMAction;
import org.elasticsearch.xpack.slm.action.RestStopSLMAction;
import org.elasticsearch.xpack.slm.action.TransportDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.TransportGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.TransportPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportStartSLMAction;
import org.elasticsearch.xpack.slm.action.TransportStopSLMAction;

public class IndexLifecycle
extends Plugin
implements ActionPlugin {
    private final SetOnce<IndexLifecycleService> indexLifecycleInitialisationService = new SetOnce();
    private final SetOnce<SnapshotLifecycleService> snapshotLifecycleService = new SetOnce();
    private final SetOnce<SnapshotRetentionService> snapshotRetentionService = new SetOnce();
    private final SetOnce<SnapshotHistoryStore> snapshotHistoryStore = new SetOnce();
    private Settings settings;
    private boolean ilmEnabled;
    private boolean slmEnabled;
    private boolean transportClientMode;

    public IndexLifecycle(Settings settings) {
        this.settings = settings;
        this.ilmEnabled = (Boolean)XPackSettings.INDEX_LIFECYCLE_ENABLED.get(settings);
        this.slmEnabled = (Boolean)XPackSettings.SNAPSHOT_LIFECYCLE_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, IndexLifecycleFeatureSet.class));
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, SLMFeatureSet.class));
        return modules;
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, LifecycleSettings.LIFECYCLE_NAME_SETTING, LifecycleSettings.LIFECYCLE_ORIGINATION_DATE_SETTING, LifecycleSettings.LIFECYCLE_PARSE_ORIGINATION_DATE_SETTING, LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING, RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING, LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING, LifecycleSettings.SLM_RETENTION_SCHEDULE_SETTING, LifecycleSettings.SLM_RETENTION_DURATION_SETTING);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.ilmEnabled) {
            this.indexLifecycleInitialisationService.set((Object)new IndexLifecycleService(this.settings, client, clusterService, threadPool, this.getClock(), System::currentTimeMillis, xContentRegistry));
            components.add(this.indexLifecycleInitialisationService.get());
        }
        if (this.slmEnabled) {
            SnapshotLifecycleTemplateRegistry templateRegistry = new SnapshotLifecycleTemplateRegistry(this.settings, clusterService, threadPool, client, xContentRegistry);
            this.snapshotHistoryStore.set((Object)new SnapshotHistoryStore(this.settings, (Client)new OriginSettingClient(client, "index_lifecycle"), clusterService));
            this.snapshotLifecycleService.set((Object)new SnapshotLifecycleService(this.settings, () -> new SnapshotLifecycleTask(client, clusterService, (SnapshotHistoryStore)this.snapshotHistoryStore.get()), clusterService, this.getClock()));
            this.snapshotRetentionService.set((Object)new SnapshotRetentionService(this.settings, () -> new SnapshotRetentionTask(client, clusterService, System::nanoTime, (SnapshotHistoryStore)this.snapshotHistoryStore.get(), threadPool), clusterService, this.getClock()));
            components.addAll(Arrays.asList(this.snapshotLifecycleService.get(), this.snapshotHistoryStore.get(), this.snapshotRetentionService.get()));
        }
        return components;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.emptyList();
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("index_lifecycle", new String[0]), parser -> (MetaData.Custom)IndexLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("snapshot_lifecycle", new String[0]), parser -> (MetaData.Custom)SnapshotLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(LifecycleType.class, new ParseField("timeseries", new String[0]), (p, c) -> TimeseriesLifecycleType.INSTANCE), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("allocate", new String[0]), AllocateAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("forcemerge", new String[0]), ForceMergeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("readonly", new String[0]), ReadOnlyAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollover", new String[0]), RolloverAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("shrink", new String[0]), ShrinkAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("delete", new String[0]), DeleteAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("freeze", new String[0]), FreezeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("set_priority", new String[0]), SetPriorityAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("unfollow", new String[0]), UnfollowAction::parse));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        if (this.ilmEnabled) {
            handlers.addAll(Arrays.asList(new BaseRestHandler[]{new RestPutLifecycleAction(restController), new RestGetLifecycleAction(restController), new RestDeleteLifecycleAction(restController), new RestExplainLifecycleAction(restController), new RestRemoveIndexLifecyclePolicyAction(restController), new RestMoveToStepAction(restController), new RestRetryAction(restController), new RestStopAction(restController), new RestStartILMAction(restController), new RestGetStatusAction(restController)}));
        }
        if (this.slmEnabled) {
            handlers.addAll(Arrays.asList(new BaseRestHandler[]{new RestPutSnapshotLifecycleAction(restController), new RestDeleteSnapshotLifecycleAction(restController), new RestGetSnapshotLifecycleAction(restController), new RestExecuteSnapshotLifecycleAction(restController), new RestGetSnapshotLifecycleStatsAction(restController), new RestExecuteSnapshotRetentionAction(restController), new RestStopSLMAction(restController), new RestStartSLMAction(restController), new RestGetSLMStatusAction(restController)}));
        }
        return handlers;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        if (this.ilmEnabled) {
            actions.addAll(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutLifecycleAction.INSTANCE, TransportPutLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetLifecycleAction.INSTANCE, TransportGetLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteLifecycleAction.INSTANCE, TransportDeleteLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExplainLifecycleAction.INSTANCE, TransportExplainLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RemoveIndexLifecyclePolicyAction.INSTANCE, TransportRemoveIndexLifecyclePolicyAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MoveToStepAction.INSTANCE, TransportMoveToStepAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RetryAction.INSTANCE, TransportRetryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartILMAction.INSTANCE, TransportStartILMAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopILMAction.INSTANCE, TransportStopILMAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetStatusAction.INSTANCE, TransportGetStatusAction.class, new Class[0])));
        }
        if (this.slmEnabled) {
            actions.addAll(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutSnapshotLifecycleAction.INSTANCE, TransportPutSnapshotLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteSnapshotLifecycleAction.INSTANCE, TransportDeleteSnapshotLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleAction.INSTANCE, TransportGetSnapshotLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotLifecycleAction.INSTANCE, TransportExecuteSnapshotLifecycleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleStatsAction.INSTANCE, TransportGetSnapshotLifecycleStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotRetentionAction.INSTANCE, TransportExecuteSnapshotRetentionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartSLMAction.INSTANCE, TransportStartSLMAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopSLMAction.INSTANCE, TransportStopSLMAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetSLMStatusAction.INSTANCE, TransportGetSLMStatusAction.class, new Class[0])));
        }
        return actions;
    }

    public void onIndexModule(IndexModule indexModule) {
        if (this.ilmEnabled) {
            assert (this.indexLifecycleInitialisationService.get() != null);
            indexModule.addIndexEventListener((IndexEventListener)this.indexLifecycleInitialisationService.get());
        }
    }

    public void close() {
        try {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.indexLifecycleInitialisationService.get(), (Closeable)this.snapshotLifecycleService.get(), (Closeable)this.snapshotRetentionService.get()});
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to close index lifecycle services", (Throwable)e, new Object[0]);
        }
    }
}

