/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.DeleteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.AbstractEnrichProcessor;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportDeleteEnrichPolicyAction
extends TransportMasterNodeAction<DeleteEnrichPolicyAction.Request, AcknowledgedResponse> {
    private final EnrichPolicyLocks enrichPolicyLocks;
    private final IngestService ingestService;
    private final Client client;
    private static final IndicesOptions LENIENT_OPTIONS = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)true);

    @Inject
    public TransportDeleteEnrichPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, EnrichPolicyLocks enrichPolicyLocks, IngestService ingestService) {
        super("cluster:admin/xpack/enrich/delete", transportService, clusterService, threadPool, actionFilters, DeleteEnrichPolicyAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.enrichPolicyLocks = enrichPolicyLocks;
        this.ingestService = ingestService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteEnrichPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        EnrichPolicy policy = EnrichStore.getPolicy(request.getName(), state);
        if (policy == null) {
            throw new ResourceNotFoundException("policy [{}] not found", new Object[]{request.getName()});
        }
        this.enrichPolicyLocks.lockPolicy(request.getName());
        try {
            List pipelines = IngestService.getPipelines((ClusterState)state, (String[])new String[0]);
            ArrayList<String> pipelinesWithProcessors = new ArrayList<String>();
            for (PipelineConfiguration pipelineConfiguration : pipelines) {
                List enrichProcessors = this.ingestService.getProcessorsInPipeline(pipelineConfiguration.getId(), AbstractEnrichProcessor.class);
                for (AbstractEnrichProcessor processor : enrichProcessors) {
                    if (!processor.getPolicyName().equals(request.getName())) continue;
                    pipelinesWithProcessors.add(pipelineConfiguration.getId());
                }
            }
            if (!pipelinesWithProcessors.isEmpty()) {
                throw new ElasticsearchStatusException("Could not delete policy [{}] because a pipeline is referencing it {}", RestStatus.CONFLICT, new Object[]{request.getName(), pipelinesWithProcessors});
            }
        }
        catch (Exception e) {
            this.enrichPolicyLocks.releasePolicy(request.getName());
            listener.onFailure(e);
            return;
        }
        this.deleteIndicesAndPolicy(request.getName(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(response -> {
            this.enrichPolicyLocks.releasePolicy(request.getName());
            listener.onResponse(response);
        }, exc -> {
            this.enrichPolicyLocks.releasePolicy(request.getName());
            listener.onFailure(exc);
        }));
    }

    private void deleteIndicesAndPolicy(String name, ActionListener<AcknowledgedResponse> listener) {
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest().indices(new String[]{EnrichPolicy.getBaseName((String)name) + "-*"}).indicesOptions(LENIENT_OPTIONS);
        this.client.admin().indices().delete(deleteRequest, ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Could not fetch indices to delete during policy delete of [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{name}));
            } else {
                this.deletePolicy(name, listener);
            }
        }, error -> listener.onFailure(error)));
    }

    private void deletePolicy(String name, ActionListener<AcknowledgedResponse> listener) {
        EnrichStore.deletePolicy(name, this.clusterService, e -> {
            if (e == null) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteEnrichPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

