/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.enrich.AbstractEnrichProcessor;

public final class GeoMatchProcessor
extends AbstractEnrichProcessor {
    private ShapeRelation shapeRelation;

    GeoMatchProcessor(String tag, Client client, String policyName, String field, String targetField, boolean overrideEnabled, boolean ignoreMissing, String matchField, int maxMatches, ShapeRelation shapeRelation) {
        super(tag, client, policyName, field, targetField, ignoreMissing, overrideEnabled, matchField, maxMatches);
        this.shapeRelation = shapeRelation;
    }

    GeoMatchProcessor(String tag, BiConsumer<SearchRequest, BiConsumer<SearchResponse, Exception>> searchRunner, String policyName, String field, String targetField, boolean overrideEnabled, boolean ignoreMissing, String matchField, int maxMatches, ShapeRelation shapeRelation) {
        super(tag, searchRunner, policyName, field, targetField, ignoreMissing, overrideEnabled, matchField, maxMatches);
        this.shapeRelation = shapeRelation;
    }

    @Override
    public QueryBuilder getQueryBuilder(Object fieldValue) {
        ArrayList<Point> points = new ArrayList<Point>();
        if (fieldValue instanceof List) {
            List values = (List)fieldValue;
            if (values.size() == 2 && values.get(0) instanceof Number) {
                GeoPoint geoPoint = GeoUtils.parseGeoPoint((Object)values, (boolean)true);
                points.add(new Point(geoPoint.lon(), geoPoint.lat()));
            } else {
                for (Object value : values) {
                    GeoPoint geoPoint = GeoUtils.parseGeoPoint(value, (boolean)true);
                    points.add(new Point(geoPoint.lon(), geoPoint.lat()));
                }
            }
        } else {
            GeoPoint geoPoint = GeoUtils.parseGeoPoint((Object)fieldValue, (boolean)true);
            points.add(new Point(geoPoint.lon(), geoPoint.lat()));
        }
        if (points.isEmpty()) {
            throw new IllegalArgumentException("no geopoints found");
        }
        Object queryGeometry = points.size() == 1 ? (Geometry)points.get(0) : new MultiPoint(points);
        GeoShapeQueryBuilder shapeQuery = new GeoShapeQueryBuilder(this.matchField, queryGeometry);
        shapeQuery.relation(this.shapeRelation);
        return shapeQuery;
    }

    public ShapeRelation getShapeRelation() {
        return this.shapeRelation;
    }
}

