/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.GeoMatchProcessor;
import org.elasticsearch.xpack.enrich.MatchProcessor;

final class EnrichProcessorFactory
implements Processor.Factory,
Consumer<ClusterState> {
    static final String TYPE = "enrich";
    private final Client client;
    volatile MetaData metaData;

    EnrichProcessorFactory(Client client) {
        this.client = client;
    }

    public Processor create(Map<String, Processor.Factory> processorFactories, String tag, Map<String, Object> config) throws Exception {
        String policyName = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"policy_name");
        String policyAlias = EnrichPolicy.getBaseName((String)policyName);
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.metaData.getAliasAndIndexLookup().get(policyAlias);
        if (aliasOrIndex == null) {
            throw new IllegalArgumentException("no enrich index exists for policy with name [" + policyName + "]");
        }
        assert (aliasOrIndex.isAlias());
        assert (aliasOrIndex.getIndices().size() == 1);
        IndexMetaData imd = (IndexMetaData)aliasOrIndex.getIndices().get(0);
        String field = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"field");
        Map mappingAsMap = imd.mapping().sourceAsMap();
        String policyType = (String)XContentMapValues.extractValue((String)"_meta.enrich_policy_type", (Map)mappingAsMap);
        String matchField = (String)XContentMapValues.extractValue((String)"_meta.enrich_match_field", (Map)mappingAsMap);
        boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
        boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"override", (boolean)true);
        String targetField = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"target_field");
        int maxMatches = ConfigurationUtils.readIntProperty((String)TYPE, (String)tag, config, (String)"max_matches", (Integer)1);
        if (maxMatches < 1 || maxMatches > 128) {
            throw ConfigurationUtils.newConfigurationException((String)TYPE, (String)tag, (String)"max_matches", (String)"should be between 1 and 128");
        }
        switch (policyType) {
            case "match": {
                return new MatchProcessor(tag, this.client, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches);
            }
            case "geo_match": {
                String relationStr = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"shape_relation", (String)"intersects");
                ShapeRelation shapeRelation = ShapeRelation.getRelationByName((String)relationStr);
                return new GeoMatchProcessor(tag, this.client, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches, shapeRelation);
            }
        }
        throw new IllegalArgumentException("unsupported policy type [" + policyType + "]");
    }

    @Override
    public void accept(ClusterState state) {
        this.metaData = state.getMetaData();
    }
}

